#include "../Domain/SimploidPoint.h"
#include "math.h"
#include<vector>
#include<stdio.h>

namespace Domain
{
FILE* SimploidPoint::datafp; 

SimploidPoint::SimploidPoint(int order)
{
	this->order = order;
	this->type = new int[order];
	this->coord = new SimplexPoint*[order];
	
}

SimploidPoint::~SimploidPoint()
{
}



void SimploidPoint::setCoord(int coord, SimplexPoint* value)
{
	this->coord[coord] = value;
}




SimploidPoint* SimploidPoint::addPrefix(SimplexPoint* p)
{
	SimploidPoint* newp;
	int i;
	
	newp = new SimploidPoint(this->order+1);
	
	for(i=0; i<= this->order;i++)
	{
		newp->coord[i+1] = this->coord[i];
		newp->type[i+1] = this->type[i];
	}
	
	newp->coord[0]=p;
	newp->type[0] = p->dim;
	
	return newp;
	
}


std::vector<SimploidPoint*> SimploidPoint::addPrefix(SimplexPoint* p, std::vector<SimploidPoint*> v,std::vector<SimploidPoint*> acum)
{
	std::vector<SimploidPoint*>::iterator iter;
	SimploidPoint* tmp;
	
	for(iter=v.begin();iter!= v.end();iter++)
	{
		//(*iter)->print();
		//if(  ((*iter)->sum() + p) <= 1 )
		{
			tmp = (*iter)->addPrefix(p);
			acum.push_back( tmp );
			//tmp->print();
		}
	}	
	
	return acum;
}
	
void SimploidPoint::print()
{
	int i;
	fprintf(SimploidPoint::datafp,"[");
	for(i=0;i < this->order ; i++)
		this->coord[i]->print(SimploidPoint::datafp);
	fprintf(SimploidPoint::datafp,"]\n");
}

void SimploidPoint::print(FILE* fp)
{
	int i;
	fprintf(fp,"[");
	for(i=0;i < this->order ; i++)
		this->coord[i]->print(fp);
	fprintf(fp,"]\n");
}


SimploidPoint* SimploidPoint::fromSimplexPoint(SimplexPoint* p)
{
	SimploidPoint *newp = new SimploidPoint(1);
	newp->type[0] = p->dim;
	newp->coord[0] = p;
	
	return newp;
}

std::vector<SimploidPoint*> SimploidPoint::fromSimplexPointVector(std::vector<SimplexPoint*> v)
{
	std::vector<SimploidPoint*> acum;
	std::vector<SimplexPoint*>::iterator iter;
	
	for(iter=v.begin();iter!=v.end();iter++)
		acum.push_back( SimploidPoint::fromSimplexPoint((*iter)) );
	
	return acum;
		
}


std::vector<SimploidPoint*> SimploidPoint::domainPoints(int order, int* type,int n)
{
	int i;
	std::vector<SimploidPoint*> v,acum;
	std::vector<SimploidPoint*>::iterator iter;	
	
	std::vector<SimplexPoint*> v2;
	std::vector<SimplexPoint*>::iterator iter2;
	
	
	v = SimploidPoint::SimploidPoint::fromSimplexPointVector( SimplexPoint::domainPoints(type[0],n)  );
	
	
	//for(iter=v.begin();iter!= v.end();iter++)
	//	(*iter)->print(stderr);
	
	for(i=1;  i<order ;i++)
	{
		v2.clear();
		
		v2 = SimplexPoint::SimplexPoint::domainPoints(type[i],n);
		
		for(iter2=v2.begin();iter2!=v2.end();iter2++)
		{
			acum = SimploidPoint::addPrefix( (*iter2),v,acum);
		}
		v = acum;
		acum.clear();
		
	}
	
	//for(iter=v.begin();iter!= v.end();iter++)
	//	acum.push_back((*iter)->extendPoint2Simplex());
	
	return v;
}




}
