#include "TensorPoint.h"
#include "SimplexPoint.h"
//#include "../Index/MultiIdx.h"
//#include "../Index/MatrixIdx.h"
#include <vector.h>

namespace Domain
{

TensorPoint::TensorPoint(int order):SimploidPoint(order)
{
}

TensorPoint::~TensorPoint()
{
}




TensorPoint* TensorPoint::TfromSimplexPoint(SimplexPoint* p)
{
	TensorPoint* newp;
	newp= new TensorPoint(p->dim);
	SimplexPoint* paux;
	SimplexPoint* paux2;
	
	int i;
	
	for(i=0;i<p->dim;i++)
	{
		paux2 = (SimplexPoint::fromDouble(p->coord[i]));
		paux = paux2->TextendPoint2Simplex();
		newp->SimploidPoint::setCoord(i,paux);
	}
	
	return newp;
	
}




SimplexPoint* TensorPoint::toSimplexPoint()
{
	SimplexPoint* sp;
	int i;
	double acum = 0;
	
	sp = new SimplexPoint(this->order);
	
	for(i=0;i<this->order;i++)
	{
		sp->coord[i] = this->coord[i]->coord[0];
		acum = acum + sp->coord[i] ; 
	}
	
	sp->coord[i] = 1 - acum; 
	
	return sp;
}




void TensorPoint::printPlot(double v)
{
	int i;
	for(i=0;i < this->order ; i++)
		fprintf(SimploidPoint::datafp," %g ",this->coord[i]->coord[0]);
	
	fprintf(SimploidPoint::datafp,"%g \n",v);
}


}
