#include "HyperIdx.h"

namespace Index
{



MultiIdx* HyperIdx::toTensorIdx()
{
	MultiIdx* midx;
	int i;
	midx = new MultiIdx(this->n_rows);
	
	
	for(i=0;i<this->n_rows;i++)
		midx->idx[i] = this->line[i]->idx[0];
	
	return midx;
}

HyperIdx* HyperIdx::fromTensorIdx(MultiIdx* midx, int* deg)
{
	HyperIdx* hidx;
	int i;
	MultiIdx* dim = new MultiIdx(midx->size);
	
	
	for(i=0;i<dim->size;i++)
		dim->idx[i] = 1;
	
	hidx = new HyperIdx(midx->size,dim);
	
	for(i=0;i<dim->size;i++)
	{
		hidx->line[i] = Index::MultiIdx::MultiIdx::fromInteger(deg[i] - midx->idx[i]);
		hidx->line[i] = hidx->line[i]->addPrefix(midx->idx[i]);
	}
		
	return hidx;
}


int HyperIdx::equals(BezierIndex* op)
{
	int i,j;
	int res=1;	

	
	if(((HyperIdx*)op)->n_rows != this->n_rows)
		return 0;
	

	for(i=0;i<this->n_rows;i++)
	{
		if(this->line[i]->size != ((HyperIdx*)op)->line[i]->size)
			return 0;
		
		for(j=0;j<this->line[i]->size;j++)
			if(this->line[i]->get(j)!=((HyperIdx*)op)->line[i]->get(j))
				res=0;
	}	
		return res;
}


vector<HyperIdx*> HyperIdx::getAllIndexes(MultiIdx* r,MultiIdx* dim)
{
	std::vector<MultiIdx*> ivec;
	std::vector<HyperIdx*> hveca,hvecb;
	std::vector<MultiIdx*>::iterator iter;
	
	MultiIdx *midx,*newr,*newdim;
	int order = r->size;
	int i;
	
	
	if(order==1) //basis
	{
		ivec = MultiIdx::MultiIdx::getMultiIdxSet(r->idx[0],dim->idx[0]+1);
		hveca = HyperIdx::fromMultiIdxVector(ivec);
		return hveca;
	}
	
	
	
	
	//if(order==2) //basis
	{
		newr = new MultiIdx(order-1);
		newdim = new MultiIdx(order-1);
		for(i=0;i<order-1;i++)
		{
			newr->idx[i] = r->idx[i];
			newdim->idx[i] = dim->idx[i];
		}
		
		hveca = Index::HyperIdx::getAllIndexes(newr,newdim);
		
		ivec = MultiIdx::MultiIdx::getMultiIdxSet(r->idx[order-1],dim->idx[order-1]+1);
		
		for(iter=ivec.begin();iter!=ivec.end();iter++)
		{
			midx = (MultiIdx*)*iter;
			hvecb = HyperIdx::addLine(midx,hveca,hvecb);
		}
		
		
		return hvecb;
		
	}
	
	
	
	
	
}


HyperIdx* HyperIdx::clone()
{
	HyperIdx* mtx = new HyperIdx(this->n_rows,this->dim );
	int i;
	
	for(i=0;i<this->n_rows;i++)
		mtx->line[i] = this->line[i]->clone();
	
	return mtx;
}


HyperIdx* HyperIdx::sub(HyperIdx* op)
{
	HyperIdx* mtx = new HyperIdx(this->n_rows,this->dim );
	int i;
	
	for(i=0;i<this->n_rows;i++)
		mtx->line[i] = this->line[i]->sub(op->line[i]);
	
	return mtx;
}

int HyperIdx::sum()
{
	int i;
	int sum=0;
	
	for(i=0;i<this->n_rows;i++)
		sum += this->line[i]->sum();
	
	return sum;
}


HyperIdx* HyperIdx::supressFirst()
{
	HyperIdx* mtx = new HyperIdx(this->n_rows-1,(MultiIdx*)this->dim->MultiIdx::supressFirst() );
	int i;
		
	for(i=1;i<this->n_rows;i++)
		mtx->line[i-1] = this->line[i]->clone();
		
	return mtx;
}

HyperIdx* HyperIdx::supressFirstElement()
{
	HyperIdx* mtx = new HyperIdx(this->n_rows,this->dim );
	int i;
		
	mtx->line[0] = (MultiIdx*)this->line[0]->MultiIdx::supressFirst();
	
	for(i=1;i<this->n_rows;i++)
		mtx->line[i] = this->line[i]->clone();
		
	return mtx;
}


HyperIdx::HyperIdx(int rows)
{
	this->n_rows = rows;
	this->line = new MultiIdx*[rows];
}

HyperIdx::HyperIdx(int rows,MultiIdx* dim)
{
	this->n_rows = rows;
	this->line = new MultiIdx*[rows];
	this->dim = dim;
}




HyperIdx::~HyperIdx()
{
}

HyperIdx::HyperIdx()
{
}



HyperIdx* HyperIdx::fromMultiIdx(MultiIdx* i)
{
	HyperIdx* mtx = new HyperIdx(1,MultiIdx::fromInteger( i->size) );
	mtx->line[0] = i;
	
	return mtx;
}


HyperIdx* HyperIdx::fromMultiIdx(MultiIdx* i,MultiIdx* dim)
{
	if(i->size != (dim->size + dim->sum()))
		return NULL;
	
	HyperIdx* mtx = new HyperIdx(dim->size,dim);
	
	int j,jj,k;
	
	for(j=0,k=0;j< dim->size;j++)
		for(jj=0;jj<dim->idx[j];jj++,k++)
			mtx->line[j]->idx[jj] = i->idx[k];

	return mtx;
}

MultiIdx* HyperIdx::toMultiIdx()
{
	int size = (dim->size + dim->sum());
	
	MultiIdx* i = new MultiIdx(size);
	
	int j,jj,k;
	
	for(j=0,k=0;j< this->dim->size;j++)
		for(jj=0;jj< this->dim->idx[j];jj++,k++)
			 i->idx[k] = this->line[j]->idx[jj];

	return i;
}

HyperIdx* HyperIdx::getZeroHyperIdx(int order)
{
	HyperIdx* mtx;
	int i;
	
	MultiIdx* idx = new MultiIdx(order);
	
	for(i=0;i<order;i++)
		idx->idx[i]=0;
	
	mtx = new HyperIdx(order,idx);
	for(i=0;i<order;i++)
	{
		mtx->line[i] = new MultiIdx(1);
		mtx->line[i]->idx[0] = 0;
	}
	
	
	
	return mtx;
}

HyperIdx* HyperIdx::getZeroHyperIdx( int order,int* dim)
{
	HyperIdx* mtx;
	int i,j;
	
	MultiIdx* idx = new MultiIdx(order);
	
	for(i=0;i<order;i++)
		idx->idx[i]=dim[i];
	
	mtx = new HyperIdx(order,idx);
	for(i=0;i<order;i++)
	{
		mtx->line[i] = new MultiIdx(dim[i]+1);
		for(j=0;j<dim[i]+1;j++)
			mtx->line[i]->idx[j] = 0;
	}
	
	
	
	return mtx;
}

vector<HyperIdx*> HyperIdx::addLine(MultiIdx* i,std::vector<HyperIdx*> v, std::vector<HyperIdx*> acum)
{
	std::vector<HyperIdx*>::iterator iter;
	HyperIdx* mtx;
		
	for(iter=v.begin();iter!=v.end();iter++)
	{
		mtx = (*iter);
		acum.push_back(mtx->addLine(i));
	}
	
	return acum;
}

HyperIdx* HyperIdx::addLine(MultiIdx* i)
{
		
	HyperIdx* mtx = new HyperIdx(this->n_rows + 1,this->dim);
	int j;
	
	for(j=0;j<this->n_rows;j++)
	{
		mtx->line[j] = this->line[j];
	}
	mtx->line[j] = i;
	
	return mtx;
}

vector<HyperIdx*> HyperIdx::fromMultiIdxVector(std::vector<MultiIdx*> v)
{
	std::vector<HyperIdx*> newv;
	std::vector<MultiIdx*>::iterator iter;
	
	HyperIdx* mtx;
	
	for(iter=v.begin();iter!=v.end();iter++)
	{
		mtx = HyperIdx::fromMultiIdx(*iter);
		newv.push_back(mtx);
	}
	
	
	return newv;
}



void HyperIdx::print(FILE* fp)
{
	int i;
	fprintf(fp,"{");
	for(i=0;i<this->n_rows;i++)
		this->line[i]->print(fp);
	fprintf(fp,"}");
}


}
