#ifndef HYPERIDX_H_
#define HYPERIDX_H_

#include "MultiIdx.h"
#include <vector.h>

namespace Index
{

class HyperIdx
{
public:
	int n_rows;
	MultiIdx* dim;
	
	MultiIdx** line;
	MultiIdx *r;
	
	//----------------------------------//
	/* Methods
	 */
	
	
	
	/*
	 * Constructors and destructors
	 */
	HyperIdx(int rows);
	HyperIdx(int rows,MultiIdx* dim);
	HyperIdx();
	virtual ~HyperIdx();
	
	
	/*
	 * Getting particular index
	 */
	static  HyperIdx*  getZeroHyperIdx(int order);
	static  HyperIdx*  getZeroHyperIdx( int order,int* dim);
	
	
	
	/*
	 * Binary Operators
	 */
	HyperIdx*  sub(HyperIdx* op);
	
	
	/*
	 * Comparison
	 */
	int  equals(BezierIndex* op);
	
	/*
	 * Unary Operations
	 */
	HyperIdx*  clone();
	int factorial();
	int  sum();
	
	/*
	 * Modifying the index
	 */
	//Single element 
	HyperIdx* addLine(MultiIdx* i);
	HyperIdx*  supressFirst();
	HyperIdx*  supressFirstElement();
	//Several elements
	static vector<HyperIdx*> addLine(MultiIdx* i,std::vector<HyperIdx*> v, std::vector<HyperIdx*> acum);
		
	
	/*
	 * Conversion
	 */
	//Single element
	MultiIdx*  toTensorIdx();
	MultiIdx*  toMultiIdx();
	static HyperIdx* fromMultiIdx(MultiIdx* i);
	static HyperIdx* fromMultiIdx(MultiIdx* i,MultiIdx* dim);
	static HyperIdx*  fromTensorIdx(MultiIdx* midx, int* deg);
	
	//Several elements
	static vector<HyperIdx*> fromMultiIdxVector(vector<MultiIdx*> v);
	
	
		
	
	/*
	 * Obtaining set of indices
	 */	
	static vector<HyperIdx*> getAllIndexes(MultiIdx* r,MultiIdx* dim);
	
		
	
	/*
	 * Debugging methods
	 */
	void print(FILE* fp);
	
	
};

}

#endif /*HYPERIDX_H_*/
