#include "IndexedMPMatrix.h"
#include "../Numbers/Rational.h"

namespace Index
{




void IndexedMPMatrix::print(FILE *fp)
{
	int i,j;
	
	fprintf(fp,"-----IndexedMPMatrix--------\n");
	
	for(i=0;i<this->rown;i++)
	{
		for(j=0;j<this->coln;j++)
			fprintf(fp," %g",this->data[i][j]->getDouble());
		fprintf(fp,"\n");
	}
	

	fprintf(fp,"-----IndexedMPMatrix(end)--------\n");
	
	
	
}


IndexedMPMatrix::IndexedMPMatrix(int rown,int coln)
{
	
	this->rown = rown;
	this->coln = coln;
	
	this->rowIdx = (BezierIndex**)calloc(rown,sizeof(BezierIndex*));
	this->colIdx = (BezierIndex**)calloc(coln,sizeof(BezierIndex*));
	
	this->data = (Number***)calloc(rown,sizeof(Number**));
	
	
	int i,j;
	for(i=0;i<rown;i++)
	{
		this->data[i] = (Number**)calloc(coln,sizeof(Number*));
		for(j=0;j<coln;j++)
			this->data[i][j] = new Rational(0,1);
	}	
}

IndexedMPMatrix::~IndexedMPMatrix()
{
}


int IndexedMPMatrix::getCol(//input
			BezierIndex* cIdx)
{
	int col;
	
	for(col=0;((col<this->coln)&&(!this->colIdx[col]->equals(cIdx))) ;col++);
	
	if(col<this->coln)
		return col;
	else
		return -1;
}

int IndexedMPMatrix::getRow(//input
			BezierIndex* rIdx
			)
{
	int row;
	row=0;
	//int col;
	
	for(row=0;row<this->rown ;row++)
		if(this->rowIdx[row]->equals(rIdx))
			break;
	//for(col=0;((col<this->coln)&&(!this->colIdx[col]->equals(cIdx))) ;col++);
	
	if(row<this->rown)
		return row;
	else
		return -1;
	
}





void IndexedMPMatrix::getPos(//input
			BezierIndex* rIdx, BezierIndex* cIdx,
			//output
			int *rowp, int *colp
			)
{
	int row;
	int col;
	
	for(row=0;((row<this->rown)&&(!this->rowIdx[row]->equals(rIdx))) ;row++);
	for(col=0;((col<this->coln)&&(!this->colIdx[col]->equals(cIdx))) ;col++);
	
	if(row<this->rown)
		*rowp = row;
	
	if(col<this->coln)
		*colp = col;
		
	return;
}


void IndexedMPMatrix::setValue(//input
			BezierIndex* rIdx, BezierIndex* cIdx, Number *value
			)
{
	int row;
	int col;
	
	this->IndexedMPMatrix::getPos(rIdx,cIdx,&row,&col);
	this->data[row][col] = value;
	
	return;
}

Number* IndexedMPMatrix::getValue(//input
			BezierIndex* rIdx, BezierIndex* cIdx
			)
{
	int row;
	int col;
	
	this->IndexedMPMatrix::getPos(rIdx,cIdx,&row,&col);
	
	return this->data[row][col];
}



void IndexedMPMatrix::buildIndices(std::vector<BezierIndex*> row_vec,std::vector<BezierIndex*> col_vec)
{
	std::vector<BezierIndex*>::iterator iter;
	
	int i=0;
	for(iter=row_vec.begin();iter!=row_vec.end();iter++)
	{
		this->rowIdx[i] = (*iter);
		i++;
	}
	i=0;
	
	for(iter=col_vec.begin();iter!=col_vec.end();iter++)
	{
		this->colIdx[i] = (*iter);
		i++;
	}
	
	
}

}