#ifndef INDEXEDMPMATRIX_H_
#define INDEXEDMPMATRIX_H_

#include "BezierIndex.h"
#include <stdlib.h>
#include <vector.h>

#include "../Numbers/Number.h"

namespace Index
{

class IndexedMPMatrix
{
public:
	
	BezierIndex** rowIdx;
	BezierIndex** colIdx;
	int rown;
	int coln;
	
	Number ***data;
	
	
	IndexedMPMatrix(int rown,int coln);
	virtual ~IndexedMPMatrix();
	
	
	
	void  getPos(//input
				BezierIndex* rowIdx, BezierIndex* colIdx,
				//output
				int *row, int *col
				);
	
	
	
	Number*  getValue(//input
				BezierIndex* rIdx, BezierIndex* cIdx
				);
	
	void  setValue(//input
				BezierIndex* rIdx, BezierIndex* cIdx, Number *value
				);
	
	
	
	void  buildIndices(std::vector<BezierIndex*> row_vec,std::vector<BezierIndex*> col_vec);
	
	int  getCol(BezierIndex* cIdx);
	
	int  getRow(BezierIndex* rIdx);
	
	
	void  print(FILE *fp);
	
};

}

#endif /*INDEXEDMPMATRIX_H_*/
