#include "IndexedMatrix.h"

namespace Index
{




void IndexedMatrix::print(FILE *fp)
{
	int i,j;
	
	fprintf(fp,"-----IndexedMatrix--------\n");
	
	for(i=0;i<this->rown;i++)
	{
		for(j=0;j<this->coln;j++)
			fprintf(fp," %g",this->data[i][j]);
		fprintf(fp,"\n");
	}
	

	fprintf(fp,"-----IndexedMatrix(end)--------\n");
	
	
	
}


IndexedMatrix::IndexedMatrix(int rown,int coln)
{
	this->rown = rown;
	this->coln = coln;
	
	this->rowIdx = (BezierIndex**)calloc(rown,sizeof(BezierIndex*));
	this->colIdx = (BezierIndex**)calloc(coln,sizeof(BezierIndex*));
	
	this->data = (double**)calloc(rown,sizeof(double*));
	
	
	int i;
	for(i=0;i<rown;i++)
		this->data[i] = (double*)calloc(coln,sizeof(double));
		
}

IndexedMatrix::~IndexedMatrix()
{
}


int IndexedMatrix::getCol(//input
			BezierIndex* cIdx)
{
	int col;
	
	for(col=0;((col<this->coln)&&(!this->colIdx[col]->equals(cIdx))) ;col++);
	
	if(col<this->coln)
		return col;
	else
		return -1;
}

int IndexedMatrix::getRow(//input
			BezierIndex* rIdx
			)
{
	int row;
	row=0;
	//int col;
	
	for(row=0;row<this->rown ;row++)
		if(this->rowIdx[row]->equals(rIdx))
			break;
	//for(col=0;((col<this->coln)&&(!this->colIdx[col]->equals(cIdx))) ;col++);
	
	if(row<this->rown)
		return row;
	else
		return -1;
	
}





void IndexedMatrix::getPos(//input
			BezierIndex* rIdx, BezierIndex* cIdx,
			//output
			int *rowp, int *colp
			)
{
	int row;
	int col;
	
	for(row=0;((row<this->rown)&&(!this->rowIdx[row]->equals(rIdx))) ;row++);
	for(col=0;((col<this->coln)&&(!this->colIdx[col]->equals(cIdx))) ;col++);
	
	if(row<this->rown)
		*rowp = row;
	
	if(col<this->coln)
		*colp = col;
		
	return;
}


void IndexedMatrix::setValue(//input
			BezierIndex* rIdx, BezierIndex* cIdx, double value
			)
{
	int row;
	int col;
	
	this->IndexedMatrix::getPos(rIdx,cIdx,&row,&col);
	this->data[row][col] = value;
	
	return;
}

double IndexedMatrix::getValue(//input
			BezierIndex* rIdx, BezierIndex* cIdx
			)
{
	int row;
	int col;
	
	this->IndexedMatrix::getPos(rIdx,cIdx,&row,&col);
	
	return this->data[row][col];
}



void IndexedMatrix::buildIndices(std::vector<BezierIndex*> row_vec,std::vector<BezierIndex*> col_vec)
{
	std::vector<BezierIndex*>::iterator iter;
	
	int i=0;
	for(iter=row_vec.begin();iter!=row_vec.end();iter++)
	{
		this->rowIdx[i] = (*iter);
		i++;
	}
	i=0;
	
	for(iter=col_vec.begin();iter!=col_vec.end();iter++)
	{
		this->colIdx[i] = (*iter);
		i++;
	}
	
	
}

}
