#ifndef INDEXEDMATRIX_H_
#define INDEXEDMATRIX_H_

#include "BezierIndex.h"
#include <stdlib.h>
#include <vector.h>

namespace Index
{

class IndexedMatrix
{
public:
	
	BezierIndex** rowIdx;
	BezierIndex** colIdx;
	int rown;
	int coln;
	
	double **data;
	
	
	IndexedMatrix(int rown,int coln);
	virtual ~IndexedMatrix();
	
	
	
	void getPos(//input
				BezierIndex* rowIdx, BezierIndex* colIdx,
				//output
				int *row, int *col
				);
	
	
	
	double getValue(//input
				BezierIndex* rIdx, BezierIndex* cIdx
				);
	
	void setValue(//input
				BezierIndex* rIdx, BezierIndex* cIdx, double value
				);
	
	
	
	void buildIndices(std::vector<BezierIndex*> row_vec,std::vector<BezierIndex*> col_vec);
	
	int getCol(BezierIndex* cIdx);
	
	int getRow(BezierIndex* rIdx);
	
	
	void print(FILE *fp);
	
};

}

#endif /*INDEXEDMATRIX_H_*/
