#include "MatrixIdx.h"
#include "HyperIdx.h"
#include "vector.h"
//#include "../Domain/SimplexTransformation.h"
#include "../Domain/SimplexPoint.h"
#include "MultiIdx.h"

namespace Index
{

MultiIdx* MatrixIdx::getColumn(int col)
{
	MultiIdx* c = new MultiIdx(this->n_rows);
	int i;
	for(i=0;i<this->n_rows;i++)
		c->idx[i] = this->line[i]->idx[col];
	
	return c;
		                               
		                          
}

int MatrixIdx::combination(MatrixIdx* a, MatrixIdx* b)
{
	int res=1;
	int i;
	
	for(i=0;i< a->n_rows; i++)
		res = res * Index::MultiIdx::combination(a->line[i],b->line[i]);
	
	return res;
}

MatrixIdx* MatrixIdx::clone()
{
	MatrixIdx* mtx;
	mtx = new MatrixIdx(this->n_rows,this->n_cols);
	int i;
	for(i=0;i<this->n_rows;i++)
		mtx->line[i] = this->line[i]->clone();
	
	return mtx;
	
}

MatrixIdx::MatrixIdx(int rows, int cols)
{
	this->n_rows = rows;
	this->line = new MultiIdx*[rows];
	
	this->n_cols = cols;
	
}

MatrixIdx::~MatrixIdx()
{
	delete[] this->line;
}





MultiIdx* MatrixIdx::getColumnMultiIdx()
{
	MultiIdx* c = new MultiIdx(this->n_cols);
	c->setAll(0);
	int i,j;
	
	for(i=0;i<this->n_cols;i++)
		for(j=0;j<this->n_rows;j++)
			c->idx[i] = c->idx[i] + this->line[j]->idx[i];
	
	return c;
	
}


MultiIdx* MatrixIdx::getDiagonal()
{
	MultiIdx* c;
	int i;
	
	
	int min;
	min = this->n_rows;
	if(this->n_cols < min)
		min = this->n_cols;
	
	 c = new MultiIdx(min);
	
	for(i=0;i<min;i++)
		c->idx[i] = this->line[i]->idx[i];
	
	return c;
	
}







std::vector<MatrixIdx*> MatrixIdx::getAllIndexes(MultiIdx* r,MultiIdx* c, MultiIdx* i)
{
	std::vector<MatrixIdx*> v,v2;
	std::vector<MatrixIdx*>::iterator ii;	
	
	MultiIdx* mtx_diag;
	MatrixIdx* mtx;
	
	
	v = MatrixIdx::getAllIndexes(r,c);
	
	//fprintf(stderr,"c--");
	//c->print(stderr);
	
	for(ii=v.begin(); ii!=v.end();ii++)
	{
		//(*ii)->print(stderr);
		mtx = (MatrixIdx*)(*ii);
		mtx_diag = mtx->getDiagonal();
		//mtx_col->print(stderr);
		
		if(i->isEqual( mtx_diag ) )
			v2.push_back(*ii);
	}
	
	
	return v2;
	
}


std::vector<MatrixIdx*> MatrixIdx::getAllIndexes(MultiIdx* r,MultiIdx* c)
{
	std::vector<MatrixIdx*> v,v2;
	std::vector<MatrixIdx*>::iterator ii;	
	
	MultiIdx* mtx_col;
	MatrixIdx* mtx;
	
	int n_cols = c->size;
	
	v = MatrixIdx::getAllIndexes(r,n_cols);
	
	//fprintf(stderr,"c--");
	//c->print(stderr);
	
	for(ii=v.begin(); ii!=v.end();ii++)
	{
		//(*ii)->print(stderr);
		mtx = (MatrixIdx*)(*ii);
		mtx_col = mtx->getColumnMultiIdx();
		//mtx_col->print(stderr);
		
		if(c->isEqual( mtx_col ) )
			v2.push_back(*ii);
	}
	
	
	
	return v2;
	
}


std::vector<MatrixIdx*> MatrixIdx::getAllIndexes(MultiIdx* r,int n_cols)
{
	int i;
	std::vector<MatrixIdx*> result;

	std::vector<HyperIdx*> v,acum;
	std::vector<HyperIdx*>::iterator iter;	
	
	std::vector<MultiIdx*> vv;
	std::vector<MultiIdx*>::iterator ii;
	
	MatrixIdx* mtx;

	v =  HyperIdx::fromMultiIdxVector(MultiIdx::getMultiIdxSet(r->idx[0],n_cols));
	
		
	//for(iter=v.begin();iter!= v.end();iter++)
	//	(*iter)->print();
	
	for(i=1;  i< r->size ;i++)
	{
		vv = MultiIdx::getMultiIdxSet(r->idx[i],n_cols);
		
		for(ii=vv.begin(); ii!=vv.end();ii++)
		{
			acum = HyperIdx::addLine((*ii),v,acum);
		}
		v = acum;
		acum.clear();
		
	}


	for(iter=v.begin();iter!=v.end();iter++)
	{
		mtx = ((MatrixIdx*)(*iter))->clone();
		mtx->n_cols = n_cols;

		result.push_back(mtx);
	}
	v.clear();
	
	return result;
	
}

void MatrixIdx::print(FILE* fp)
{
	int i,j;
	fprintf(fp,"(\n");
	for(i=0;i<this->n_rows;i++)
	{	
		fprintf(fp,"[ ");
		for(j=0;j<this->n_cols;j++)
			fprintf(fp," %d",this->line[i]->idx[j]);
		fprintf(fp," ]\n");
	}
	fprintf(fp,");\n");
}


int MatrixIdx::factorial()
{
	int res=1;
	int i;
	for(i=0;i<this->n_rows;i++)
	{
		res = res * this->line[i]->factorial();	
	}
	
	
	return res;
}


Integer* MatrixIdx::mpfactorial()
{
	
	int i;
	 Integer *acum,*fac,*aux;
	 
	 acum = new Integer(1);
	 
	 for(i=0;i<this->n_rows;i++)
	 {
		 fac = this->line[i]->MultiIdx::mpfactorial();
		 aux = acum->mul(fac);
		 delete fac;
		 delete acum;
		 
		 acum = aux;
	 }
	
	 return acum;
	
}

MatrixIdx* MatrixIdx::fromStar(Index::MultiIdx* a, Index::MultiIdx* b) throw (const char*)
{
	if(a->size!=b->size)
		throw "Size mismatch";

	MatrixIdx* mtx = new MatrixIdx(a->size,2);
	
	int i;
	for(i=0;i<a->size ;i++)
	{
		mtx->line[i] = new Index::MultiIdx(2);
		mtx->line[i]->idx[0] = a->idx[i];
		mtx->line[i]->idx[1] = b->idx[i] - a->idx[i];
	}

	return mtx;
}


bool MatrixIdx::isGreaterEqThan(MatrixIdx *op ) throw (const char*)
{
	int i;
	
	
	// Size mismatch
	if((this->n_rows != op->n_rows)||(this->n_cols!= op->n_cols))
		throw "Size mismatch";
			
	for(i=0;i<this->n_rows;i++)
	{
		if( ! ( this->line[i]->isGreaterEqThan(op->line[i]) )  )
			return false;
	}
	
	
	return true;
}


}
