#ifndef MATRIXIDX_H_
#define MATRIXIDX_H_

#include "MultiIdx.h"
#include "HyperIdx.h"
#include <vector.h>

#include "../Numbers/Integer.h"
//#include "../Domain/SimplexTransformation.h"

namespace Index
{

class MatrixIdx: public Index::HyperIdx
{
public:
	int n_cols;
	
	MultiIdx *col_sum;
	
	MatrixIdx(int rows, int cols);
	~MatrixIdx();
	
	void  print(FILE* fp);
	
	MultiIdx* getColumn(int col);
	
	static int  combination(MatrixIdx* a, MatrixIdx* b);
	
	MatrixIdx*  clone();
	
	MatrixIdx*  addLine(MultiIdx* i);
	MultiIdx*  getColumnMultiIdx();
	MultiIdx*  getDiagonal();
	
	bool  isGreaterEqThan(MatrixIdx *op ) throw (const char*);

	int  factorial();
	Integer*  mpfactorial();

	
	 //-------- static methods -------------------
		
	static std::vector<MatrixIdx*>  getAllIndexes(MultiIdx* r,int n_cols);
	
	static std::vector<MatrixIdx*>  getAllIndexes(MultiIdx* r,MultiIdx* c);
	
	static std::vector<MatrixIdx*>  getAllIndexes(MultiIdx* r,MultiIdx* c, MultiIdx* i);
	
	static MatrixIdx*  fromStar(MultiIdx* a, MultiIdx* b) throw (const char*);
	
	
};

}

#endif /*MATRIXIDX_H_*/
