#include "MultiIdx.h"
#include<stdio.h>

namespace Index
{


bool MultiIdx::isCompatible(MultiIdx* op)
{
	return((this->size + this->sum())==(op->size + op->sum()));
}

BezierIndex *MultiIdx::supressFirst()
{
	MultiIdx *i;
	
	i = new MultiIdx(this->size-1);
	
	int j;
	for(j=1;j<this->size;j++)
		i->idx[j-1] = this->MultiIdx::get(j);
	
	return (BezierIndex*)i;
}




int MultiIdx::get(int i)
{
	return this->idx[i];
}


int MultiIdx::equals(BezierIndex* op)
{
	int res=1;
		
		int i;
		for(i=0;i<this->size;i++)
			if(this->get(i)!=op->get(i))
				res=0;
		
		return res;
}

int MultiIdx::equals(MultiIdx* op)
{
	int res=1;
	
	int i;
	for(i=0;i<this->size;i++)
		if(this->get(i)!=op->get(i))
			res=0;
	
	return res;
}


MultiIdx::MultiIdx()
{
	size = 0;
	idx = NULL;
}

MultiIdx::MultiIdx(int s)
{
	size = s;
	if(s>0)
		this->idx = new int[size];
	//else--> invalid index
		
}

MultiIdx::~MultiIdx()
{
	delete this->idx;
}


MultiIdx* MultiIdx::clone()
{
	MultiIdx *c;
	int i;
	
	c = new MultiIdx(this->size);
	
	for(i=0;i<c->size;i++)
		c->idx[i] = this->idx[i];
	
	return c;
}

void MultiIdx::freeAll()
{
	if(idx==NULL)
		return;
	
	
	delete idx;
	idx=NULL;
}




int & MultiIdx::operator[](const int location)   throw (const char *) 
{
    if (location < 0 || location >= size)
    	throw "Invalid array access";
    else 
    	return idx[location];
}

bool MultiIdx::isLessThan(MultiIdx *op ) throw (const char*)
{
	int i;
	
	
	// Size mismatch
	if(this->size != op->size)
	{
		throw "Size mismatch";
	}
	
			
	for(i=0;i<this->size;i++)
	{
		if( ( this->idx[i] > op->idx[i] )||
				( this->idx[i] == op->idx[i] ) )
			return false;
	}
	
	
	return true;
}

bool MultiIdx::isLessEqThan(MultiIdx *op ) throw (const char*)
{
	int i;
	
	
	// Size mismatch
	if(this->size != op->size)
	{
		throw "Size mismatch";
	}
	
			
	for(i=0;i<this->size;i++)
	{
		if(  this->idx[i] > op->idx[i] )
				
			return false;
	}
	
	
	return true;
}

bool MultiIdx::isGreaterThan(MultiIdx *op ) throw (const char*)
{
	int i;
	
	
	// Size mismatch
	if(this->size != op->size)
	{
		throw "Size mismatch";
	}
	
			
	for(i=0;i<this->size;i++)
	{
		if( ( this->idx[i] < op->idx[i] )||
				( this->idx[i] == op->idx[i] ) )
			return false;
	}
	
	
	return true;
}

bool MultiIdx::isGreaterEqThan(MultiIdx *op ) throw (const char*)
{
	int i;
	
	
	// Size mismatch
	if(this->size != op->size)
	{
		throw "Size mismatch";
	}
	
			
	for(i=0;i<this->size;i++)
	{
		if(  this->idx[i] < op->idx[i] )
			return false;
	}
	
	
	return true;
}

bool MultiIdx::isEqual(MultiIdx *op ) throw (const char*)
{
	int i;
	
	
	// Size mismatch
	if(this->size != op->size)
	{
		throw "Size mismatch";
	}
	
			
	for(i=0;i<this->size;i++)
	{
		if(  this->idx[i] != op->idx[i] )
			return false;
	}
	
	
	return true;
}


MultiIdx* MultiIdx::append(MultiIdx *op ) throw (const char*)
{
	int i;
	MultiIdx* res;
	
	
	res = new MultiIdx(this->size + op->size);
			
	for(i=0;i<this->size;i++)
		res->idx[i] = this->idx[i];
	
	for(i=0;i<op->size;i++)
			res->idx[i+this->size] = op->idx[i];
	
	
	return res;
}

MultiIdx* MultiIdx::add(MultiIdx *op ) throw (const char*)
{
	int i;
	MultiIdx* res;
	
	// Size mismatch
	if(this->size != op->size)
	{
		throw "Size mismatch";
	}
	
	
	res = new MultiIdx(this->size);
			
	for(i=0;i<this->size;i++)
	{
		res->idx[i] = this->idx[i] + op->idx[i];
	}
	
	return res;
}

MultiIdx* MultiIdx::sub(MultiIdx *op ) throw (const char*)
{
	int i;
	MultiIdx* res;
	
	// Size mismatch
	if(this->size != op->size)
	{
		throw "Size mismatch";
	}
	
	
	res = new MultiIdx(this->size);
			
	for(i=0;i<this->size;i++)
	{
		res->idx[i] = this->idx[i] - op->idx[i];
	}
	
	return res;
}


Integer* MultiIdx::mpfactorial() 
{
	int i;
	Integer *res = new Integer(1);
	Integer *acum,*fac;
	
	for(i=0;i<this->size;i++)
	{
		acum = res;
		fac = Integer::Integer::factorial(this->idx[i]);
		res = acum->Integer::mul(fac);
		
		delete acum;
		delete fac;
	}
	
	return res;
    
}

const int MultiIdx::factorial() 
{
	int i,j;
	int res=1;
	
		
	for(i=0;i<this->size;i++)
		for(j=2;j<=this->idx[i];j++)
			res = res * j;
	
	return res;
    
}

int MultiIdx::sum() 
{
	int i;
	int res=0;
	
		
	for(i=0;i<this->size;i++)
		res = res + this->idx[i];
	
	return res;
    
}


int MultiIdx::max()
{
	int i,max;
	max = -1;
	
	for(i=0;i<this->size;i++)
	{
		if(this->idx[i]>max)
			max = this->idx[i];
	}
	
	return max;
}

void MultiIdx::setAll(int value)
{
	int i;
	for(i=0;i<this->size;i++)
		this->idx[i]=value;
}


void MultiIdx::println(FILE *fp)
{
	int i;
	for(i=0;i<this->size;i++)
		fprintf(fp," %d",this->idx[i]);
	
	//fprintf(fp,"\n");
}

void MultiIdx::print(FILE *fp)
{
	int i;
	for(i=0;i<this->size;i++)
		fprintf(fp," %d",this->idx[i]);
	
	//fprintf(fp,"\n");
}

void MultiIdx::print()
{
	int i;
	for(i=0;i<this->size;i++)
		fprintf(stderr," %d",this->idx[i]);
	
	fprintf(stderr,"\n");
}


MultiIdx* MultiIdx::addPrefix(int p)
{
	MultiIdx *a = new MultiIdx(this->size+1);
	
	int i;
	for(i=0;i<this->size;i++)
		{
			a->idx[i+1] = this->idx[i];
		}
	a->idx[0]=p;
	
	
	return a;
	
}



//-------------- static methods -------------
std::vector<MultiIdx*> MultiIdx::addPrefix(int p, std::vector<MultiIdx*> v, std::vector<MultiIdx*> acum)
{
	std::vector<MultiIdx*>::iterator iter;
	MultiIdx* tmp;
	
	for(iter = v.begin(); iter!=v.end();iter++)
	{
		tmp = (*iter)->addPrefix(p);
		acum.push_back(tmp);
		//(*iter)->print();
		//tmp->print();
	}
	
	return acum;
	
}

MultiIdx* MultiIdx::fromInteger(int p)
{
	MultiIdx* c;
	c = new MultiIdx(1);
	c->idx[0] = p;
	
	return c;
}
//--------------------------------------------------------------------------------


std::vector<MultiIdx*> MultiIdx::getLessThan()
{
	int i,j;
	std::vector<MultiIdx*> v,acum;
	
	
	for(j=0;j<this->idx[this->size-1];j++)
	{
		v.push_back(MultiIdx::fromInteger(j));
	}
	
	
	
	for(i=this->size-2;i>=0;i--)
	{
		for(j=0;j<this->idx[i];j++)
		{
			
			acum = MultiIdx::addPrefix(j,v,acum);
			
		}
		v = acum;
		acum.clear();
		
	}
	
	
	return v;
	
}

std::vector<MultiIdx*> MultiIdx::getLessEqThan()
{
	int i,j;
	std::vector<MultiIdx*> v,acum;
	
	
	for(j=0;j<=this->idx[this->size-1];j++)
	{
		v.push_back(MultiIdx::fromInteger(j));
	}
	
	
	
	for(i=this->size-2;i>=0;i--)
	{
		for(j=0;j<=this->idx[i];j++)
		{
			
			acum = MultiIdx::addPrefix(j,v,acum);
			
		}
		v = acum;
		acum.clear();
		
	}
	
	
	return v;
	
}



std::vector<MultiIdx*> MultiIdx::selectGreaterFrom(std::vector<MultiIdx*> v)
{
	std::vector<MultiIdx*> acum;
	std::vector<MultiIdx*>::iterator iter;
	
	for(iter=v.begin();iter!=v.end();iter++)
		if( (*iter)->isGreaterThan(this)  )
			acum.push_back((*iter));
	
	
	return acum;
}

std::vector<MultiIdx*> MultiIdx::selectGreaterEqFrom(std::vector<MultiIdx*> v)
{
	std::vector<MultiIdx*> acum;
	std::vector<MultiIdx*>::iterator iter;
	
	for(iter=v.begin();iter!=v.end();iter++)
		if( (*iter)->isGreaterEqThan(this)  )
			acum.push_back((*iter));
	
	
	return acum;
}

std::vector<MultiIdx*> MultiIdx::selectLessFrom(std::vector<MultiIdx*> v)
{
	std::vector<MultiIdx*> acum;
	std::vector<MultiIdx*>::iterator iter;
	
	for(iter=v.begin();iter!=v.end();iter++)
		if( (*iter)->isLessThan(this)  )
			acum.push_back((*iter));
	
	
	return acum;
}

std::vector<MultiIdx*> MultiIdx::selectLessEqFrom(std::vector<MultiIdx*> v)
{
	std::vector<MultiIdx*> acum;
	std::vector<MultiIdx*>::iterator iter;
	
	for(iter=v.begin();iter!=v.end();iter++)
		if( (*iter)->isLessEqThan(this)  )
			acum.push_back((*iter));
	
	
	return acum;
}


std::vector<MultiIdx*> MultiIdx::getMultiIdxSet(int sum,int size)
{
	std::vector<MultiIdx*> v,res;
	std::vector<MultiIdx*>::iterator iter;
	
	MultiIdx* top = new MultiIdx(size);
	top->setAll(sum+1);
	
	v = top->getLessThan();
	
	for(iter=v.begin();iter!=v.end();iter++)
			if( (*iter)->sum() == sum  )
				res.push_back((*iter));
	
	return res;	
	
}

std::vector<MultiIdx*> MultiIdx::getMultiIdxSetLessEq(int sum,int size)
{
	std::vector<MultiIdx*> v,res;
	std::vector<MultiIdx*>::iterator iter;
	
	MultiIdx* top = new MultiIdx(size);
	top->setAll(sum+1);
	
	v = top->getLessThan();
	
	for(iter=v.begin();iter!=v.end();iter++)
			if( (*iter)->sum() <= sum  )
				res.push_back((*iter));
	
	return res;
		
	
	
	
}

 int MultiIdx::combination(MultiIdx* n, MultiIdx* k)
 {
	MultiIdx *aux;
	aux = n->sub(k);
	
	return  (  n->factorial()/ ( aux->factorial() * k->factorial() )  );
 }


 Integer* MultiIdx::mpcombination(MultiIdx* n, MultiIdx* k)
 {
	 int i;
	 Integer *acum,*comb,*aux;
	 
	 acum = new Integer(1);
	 
	 for(i=0;i<n->size;i++)
	 {
		 comb = Integer::Integer::combination(n->idx[i],k->idx[i]);
		 aux = acum->mul(comb);
		 delete comb;
		 delete acum;
		 
		 acum = aux;
	 }
	
	 return acum;
	 
  }
 
 
 std::vector<BezierIndex*> MultiIdx::upcastVector(std::vector<MultiIdx*> v)
 {
	 std::vector<BezierIndex*> vres;
	 std::vector<MultiIdx*>::iterator iter;
	 
	 for(iter=v.begin();iter!=v.end();iter++)
		 vres.push_back(*iter);
	 
	 return vres;
 }
 
 
}
