#ifndef MULTIIDX_H_
#define MULTIIDX_H_

#include<vector>
#include "BezierIndex.h"
#include <gmpxx.h>
#include "../Numbers/Integer.h"

namespace Index
{

class MultiIdx : public BezierIndex
{
public:
	int size;
	int *idx;
	
public:
	MultiIdx(int s);
	MultiIdx();
	virtual ~MultiIdx();
	
	int  get(int i);
	
	//Operators
	
	int  equals(MultiIdx* op);
	
	
	int  equals(BezierIndex* op);
	
	//Unary
	int &  operator[](const int location)   throw (const char *);
	const int  factorial();
	
	Integer*  mpfactorial();
	
	
	int  max();
	int  sum();
	
	BezierIndex * supressFirst();
	
	
	
	//Binary
	//------Comparison
	bool  isEqual(MultiIdx *op ) throw (const char*);
	bool  isGreaterThan(MultiIdx *op ) throw (const char*);
	bool  isGreaterEqThan(MultiIdx *op ) throw (const char*);
	bool  isLessThan(MultiIdx *op ) throw (const char*);
	bool  isLessEqThan(MultiIdx *op ) throw (const char*);
	
	//------Calculations
	MultiIdx*  add(MultiIdx *op ) throw (const char*);
	MultiIdx*  sub(MultiIdx *op ) throw (const char*);
	MultiIdx*  append(MultiIdx *op ) throw (const char*);
	MultiIdx*  addPrefix(int p);
	
	
	
//Methods
public:
	
	bool isCompatible(MultiIdx* op);
		
	void  setAll(int value);
	
	
	MultiIdx*  clone();
	
	
	 static std::vector<BezierIndex*>  upcastVector(std::vector<MultiIdx*> v);
	
//--- Build a vector of MultiIdx cointaining:
	
	//-- Only elements that are less than the object 
	std::vector<MultiIdx*>  getLessThan();
	
	//-- Only elements that are less-or-equal the object
	std::vector<MultiIdx*>  getLessEqThan();
	
	
//--- Selects from a vector of MultiIdx:
	
	//-- Only elements that are greater than the object
	std::vector<MultiIdx*>  selectGreaterFrom(std::vector<MultiIdx*> v);
	std::vector<MultiIdx*>  selectGreaterEqFrom(std::vector<MultiIdx*> v);
	//-- Only elements that are less than the object
	std::vector<MultiIdx*>  selectLessFrom(std::vector<MultiIdx*> v);
	std::vector<MultiIdx*>  selectLessEqFrom(std::vector<MultiIdx*> v);
	
	

	
//-------Static methods
	static MultiIdx*  fromInteger(int p);
	static std::vector<MultiIdx*>  getMultiIdxSet(int sum,int size);
	static std::vector<MultiIdx*>  getMultiIdxSetLessEq(int sum,int size);
	
	static int  combination(MultiIdx* n, MultiIdx* k);
	static Integer*  mpcombination(MultiIdx* n, MultiIdx* k);
	
	
//-------Debugging
	void  print();
	void  print(FILE *fp);
	void  println(FILE *fp);	
	
	
private:
	void freeAll();
	static std::vector<MultiIdx*>  addPrefix(int p, std::vector<MultiIdx*> v,std::vector<MultiIdx*> acum);
	
};// end of class






}//end of namespace

#endif /*MULTIIDX_H_*/
