#include "Bernstein.h"

namespace MathFunction
{

Bernstein::Bernstein(int d)
{
	this->dum = d;
}

Bernstein::~Bernstein()
{
}


Rational* Bernstein::mpPsi(Index::MultiIdx* g, Index::MatrixIdx* m)
{

	Integer *cfac,*lfac,*gsumfac,*gfac,*auxi,*auxi2;
	
	Rational *psi;
	
	Index::MultiIdx* c;
	c = m->getColumnMultiIdx(); 
	
	
	cfac = c->mpfactorial();
	gfac = g->mpfactorial();
	lfac = m->mpfactorial();	
	gsumfac = Integer::Integer::factorial(g->sum());
	
	auxi =  gfac->mul(cfac);
	auxi2 = lfac->mul(gsumfac);
	psi = new Rational(auxi,auxi2);
	
	delete auxi;
	delete auxi2;
	delete cfac;
	delete gfac;
	delete lfac;
	delete gsumfac;
	
	
	return psi;
	
	
}


double Bernstein::Psi(Index::MultiIdx* g, Index::MatrixIdx* m)
{
	int lfac=1;
	int cfac=1;
	int gsumfac=1;
	int gfac;
	
	double psi;
	
	Index::MultiIdx* c;
	c = m->getColumnMultiIdx(); 
	
	
	cfac = c->factorial();
	gfac = g->factorial();
	lfac = m->factorial();	
	
	//for(i=0;i<m->n_rows;i++)
		//lfac = lfac * m->line[i]->factorial();
	
	
	
	gsumfac = Domain::SimplexPoint::Ifactorial(g->sum());
	
	psi =  (gfac*cfac);
	psi = psi/(lfac*gsumfac);
	
	//fprintf(stderr,"psi=%g\n",psi);
	
	return psi;
	
	
}


Float* Bernstein::mpPhi(Index::MultiIdx* c, Index::MultiIdx* i, Domain::AffineTransformation *T)
{
	std::vector<Index::MatrixIdx*> v,v2;
	std::vector<Index::MatrixIdx*>::iterator ii;	
	
	Float  *aux;
	Float *res;
	
	Index::MatrixIdx *l;
	
	res = new Float((double)0);
	
	
	v =Index::MatrixIdx::getAllIndexes(i,c);
	
	//fprintf(stderr,"c--");
	//c->print(stderr);
	
	for(ii=v.begin(); ii!=v.end();ii++)
	{
		l = (*ii);
		aux = T->mppowerMatrixIdx(l);
		aux->Float::div_(l->mpfactorial());
		
		res->Float::add_(aux);
		delete aux;
		
	}
	
	res->Float::mul_(c->mpfactorial());
	
	return res;

}


double Bernstein::PhiPhi2(Index::MultiIdx* alpha, Index::MultiIdx* nu, Index::MatrixIdx *L, Domain::AffineTransformation **T)
{
	//Generalization of method "evalTensoriallUsingSimplicial"
		// in a way that allows affine transformation from affine spaces 
		// of different dimensions -- not only the "canonical embedding"
		//
		// See report Gluing
		
		
		std::vector<Index::MatrixIdx*> v;
		
			std::vector<Index::MatrixIdx*>::iterator i;	

			double aux;
			Index::MatrixIdx *psi;
			int alpha_sum,alpha_sum_fac;
			
			double phi_acum;
			
			double coef,coef_in;
			int j;
			
			int m;
			
			m = L->n_rows;
			
			alpha_sum_fac=1;
			alpha_sum = alpha->sum();
			
			for(j=alpha_sum;j>1;j--)
				alpha_sum_fac *= j;
			
			
			
			
			v =Index::MatrixIdx::getAllIndexes(alpha,nu);
			
			coef = 0;
			
			for(i=v.begin(); i!=v.end();i++)
			{
				psi = (*i);
				
				phi_acum=1;
				for(j=0;j< m;j++)
					phi_acum *= Bernstein::Phi2(L->line[j],psi->line[j],T[j]);
				
				coef_in = alpha->factorial() * nu->factorial();
				coef_in = coef_in / psi->factorial();
				coef_in = coef_in / alpha_sum_fac;
							
				coef_in = coef_in * phi_acum;
				
				coef += coef_in;
			}
			
		
		
		return coef;
		

}


double Bernstein::Phi2(Index::MultiIdx* col_sum, Index::MultiIdx* row_sum, Domain::AffineTransformation *T)
{
	// Adapted implementation of method Phi
	// in order to work with "evalSimplicialUsingSimplicial2"
	// only changes in variables names
	std::vector<Index::MatrixIdx*> v,v2;
	std::vector<Index::MatrixIdx*>::iterator ii;	
	
	double res=0;
	double aux;
	Index::MatrixIdx *l;
	
	v =Index::MatrixIdx::getAllIndexes(row_sum,col_sum);
	
	
	for(ii=v.begin(); ii!=v.end();ii++)
	{
		l = (*ii);
		
		aux = T->powerMatrixIdx2(l);
		
		aux = aux/(l->factorial()) ;
		
		res = res + aux; 
		
	}

	res = res*row_sum->factorial();
	//fprintf(stderr,"%g --",res);
	return res;

}


double Bernstein::Phi(Index::MultiIdx* c, Index::MultiIdx* i, Domain::AffineTransformation *T)
{
	std::vector<Index::MatrixIdx*> v,v2;
	std::vector<Index::MatrixIdx*>::iterator ii;	
	
	double res=0;
	double aux;
	Index::MatrixIdx *l;
	
	v =Index::MatrixIdx::getAllIndexes(i,c);
	
	//fprintf(stderr,"c--");
	//c->print(stderr);
	
	for(ii=v.begin(); ii!=v.end();ii++)
	{
		l = (*ii);
		l->print(stderr);
		T->print(stderr);
		aux = T->powerMatrixIdx(l);
		fprintf(stderr,"aux=%g\n",aux);
		aux = aux/(l->factorial()) ;
		
		res = res + aux; 
		
	}
	
	res = res*c->factorial();
	
	return res;

}

double Bernstein::Gamma(Index::MultiIdx* r, Index::MultiIdx* c, Index::MultiIdx* diag )
{
	std::vector<Index::MatrixIdx*> v,v2;
	std::vector<Index::MatrixIdx*>::iterator ii;	
	
	double res=0;
	
	v =Index::MatrixIdx::MatrixIdx::getAllIndexes(r,c,diag);
	
	//fprintf(stderr,"c--");
	//c->print(stderr);
	
	for(ii=v.begin(); ii!=v.end();ii++)
	{
		res = res +Bernstein::Psi(r,(*ii));
		
		
	}
	
	
	return res;

}



Rational* Bernstein::mpGamma(Index::MultiIdx* r, Index::MultiIdx* c, Index::MultiIdx* diag )
{
	std::vector<Index::MatrixIdx*> v;
	std::vector<Index::MatrixIdx*>::iterator ii;	
	
	Rational *res,*aux1,*aux2;
	
	v =Index::MatrixIdx::MatrixIdx::getAllIndexes(r,c,diag);
	
	//fprintf(stderr,"c--");
	//c->print(stderr);
	
	res = new Rational(0,1);
	
	for(ii=v.begin(); ii!=v.end();ii++)
	{
		aux1 = Bernstein::mpPsi(r,(*ii));
		aux2 = res->Rational::add(aux1);
		delete aux1;
		delete res;
		res = aux2;
		
	}
	
	
	return res;

}


double Bernstein::evalSimplicial(int g, Index::MultiIdx *i, Domain::SimplexPoint* u)
{
	double res;
	int gfac=1;
	int j;
	
	for(j=g;j>1;j--)
		gfac = gfac*j;
	
	
	res = (gfac/i->factorial())*u->powerMultiIdx(i);
	
	return res;
}




double Bernstein::evalSimplicialDegElev(int g,Index::MultiIdx *i, 
										int newg, Domain::SimplexPoint* u)
{
	double res=0;
	double coef;
	int j, gfac,ghfac,newgfac;
	
	gfac=1;
	ghfac=1;
	newgfac=1;
	
	
	for(j=g;j>1;j--)
			gfac = gfac*j;
	
	for(j=newg;j>1;j--)
			newgfac = newgfac*j;
	
	for(j=(newg -g);j>1;j--)
			ghfac = ghfac*j;
	
	if(g==0)
		gfac=1;
	if(newg==0)
		newgfac=1;
	if(g==newg)
		ghfac=1;
	
	
	Index::MultiIdx *beta,*gamma;
	std::vector<Index::MultiIdx*> v0,v;
	std::vector<Index::MultiIdx*>::iterator iter;
	
	v0 = Index::MultiIdx::getMultiIdxSet(newg,i->size);
	v = i->selectGreaterEqFrom(v0);
	//for(iter=v.begin();iter!= v.end();iter++)
	//	(*iter)->print();
	
	//v = i->Index::MultiIdx::selectLessEqFrom(v0);
	
	
	for(iter=v.begin();iter!=v.end();iter++)
	{
		beta = (*iter);
		gamma = beta->sub(i);
		coef = ((beta->factorial())/ (i->factorial() * gamma->factorial()) );
		coef = coef * (gfac * ghfac)/newgfac;
		res = res + (coef)* Bernstein::evalSimplicial(newg,beta,u);
	}
	
	
	return res;
}


double Bernstein::Xi(int k, int g, Index::MultiIdx* h, Index::MultiIdx* f, Index::MultiIdx* j)
{
	double coef;
	int hsum = h->sum();
	Index::MultiIdx* gamma;
	Index::MultiIdx* beta;
	
	Index::MultiIdx* G;
	G = new Index::MultiIdx(j->size);
	G->setAll(g);
	

	gamma = G->sub(f);
	beta = h->sub(j);


	coef = pow((double)(-k),(double)(g-hsum)) * (Domain::SimplexPoint::Ifactorial(g)/Domain::SimplexPoint::Ifactorial(g-hsum))/h->factorial();
	coef = coef * Index::MultiIdx::combination(f,j);
	coef = coef * Index::MultiIdx::combination(gamma,beta);
	coef = coef / Index::MultiIdx::combination(G,h);

	return coef;

}



double Bernstein::XiV2(int d, int g, Index::MultiIdx* sigma, Index::MultiIdx* alpha, Index::MultiIdx* lambda)
{
	double coef;
	int rhosum;
	double coef_res = 0;

	Index::MultiIdx* rhomax;
	Index::MultiIdx* rho;
	Index::MultiIdx* gamma;
	Index::MultiIdx* beta;
	Index::MultiIdx* delta;

	rhomax = (alpha->add(lambda))->sub(sigma);

	std::vector<Index::MultiIdx*> v0,v,v2;
	std::vector<Index::MultiIdx*>::iterator iter;

	

	//Conditions
	v0 = rhomax->getLessEqThan();
	//v0 = Index::MultiIdx::getMultiIdxSetLessEq(g,lambda->size);
	v2 = lambda->Index::MultiIdx::selectGreaterEqFrom(v0);


	for(iter=v2.begin();iter!=v2.end();iter++)
	{
		rho = (*iter);
		rhosum = rho->sum();
		
		if(rhosum>g)
			continue;
		
		gamma = alpha->sub(rho);
		beta = alpha->sub(sigma);
		delta = rho->sub(lambda);

		if(rhosum!=g)
			coef = pow((double)(1-d),(double)(g-rhosum));
		else
			coef = 1;
		//fprintf(stderr,"c1=%g\n",coef);
		
		coef = coef * (Domain::SimplexPoint::Ifactorial(g));
		//fprintf(stderr,"c2=%g\n",coef);
		
		coef = coef/(Domain::SimplexPoint::Ifactorial(g-rhosum));
		//fprintf(stderr,"c3=%g\n",coef);
		
		coef = coef* (gamma->factorial()) / (alpha->factorial());
		//fprintf(stderr,"c4=%g\n",coef);

		coef = coef * Index::MultiIdx::combination(sigma,lambda);
		//fprintf(stderr,"c5=%g\n",coef);
		
		coef = coef * Index::MultiIdx::combination(beta,delta);
		//fprintf(stderr,"c6=%g\n",coef);
		
		coef_res = coef_res + coef;
		//fprintf(stderr,"coef_Res=%g\n",coef_res);

	}


	
	return coef_res;

}


Rational* Bernstein::mpXiV2(int d, int g, Index::MultiIdx* sigma, Index::MultiIdx* alpha, Index::MultiIdx* lambda)
{
	Rational *coef,*coef_res;
	Integer* Iaux;
	Rational *Qaux;
	int rhosum;

	coef_res = new Rational(0,1);
	
	
	Index::MultiIdx* rhomax;
	Index::MultiIdx* rho;
	Index::MultiIdx* gamma;
	Index::MultiIdx* beta;
	Index::MultiIdx* delta;

	rhomax = (alpha->add(lambda))->sub(sigma);

	std::vector<Index::MultiIdx*> v0,v,v2;
	std::vector<Index::MultiIdx*>::iterator iter;

	

	//Conditions
	v0 = rhomax->getLessEqThan();
	//v0 = Index::MultiIdx::getMultiIdxSetLessEq(g,lambda->size);
	v2 = lambda->Index::MultiIdx::selectGreaterEqFrom(v0);


	for(iter=v2.begin();iter!=v2.end();iter++)
	{
		rho = (*iter);
		rhosum = rho->sum();
		
		if(rhosum>g)
			continue;
		
		gamma = alpha->sub(rho);
		beta = alpha->sub(sigma);
		delta = rho->sub(lambda);

		
		coef = Rational::Rational::ipow((1-d),(g-rhosum));
		
		
		
		
		Qaux = Rational::Rational::factorial(g);
		coef->Rational::mul_( Qaux);
		delete Qaux;
		

		
		Qaux= Rational::Rational::factorial(g-rhosum);
		coef->Rational::div_(Qaux);
		delete Qaux;
		
		
		
		Iaux= gamma->mpfactorial();
		Qaux = new Rational(Iaux);
		coef->Rational::mul_(Qaux);
		delete Qaux;
		delete Iaux;
				
		Iaux= alpha->mpfactorial();
		Qaux = new Rational(Iaux);
		coef->Rational::div_(Qaux);
		delete Qaux;
		delete Iaux;
	
		
		Iaux= Index::MultiIdx::mpcombination(sigma,lambda);
		Qaux = new Rational(Iaux);
		coef->Rational::mul_(Qaux);
		delete Qaux;
		delete Iaux;
			
		Iaux= Index::MultiIdx::mpcombination(beta,delta);
		Qaux = new Rational(Iaux);
		coef->Rational::mul_(Qaux);
		delete Qaux;
		delete Iaux;
				
		
		coef_res->Rational::add_(coef);
		delete coef;
	}


	
	return coef_res;

}



double Bernstein::evalSimplicialUsingTensorV2(int g,Index::MultiIdx *i, Domain::SimplexPoint* u)
{
	double res=0;
	double coef;
	int k;
	int ii;

	
	
	k = i->size-1;
	
	Index::MultiIdx* lambda;


	lambda = new Index::MultiIdx(i->size-1);
	for(ii=0;ii<lambda->size;ii++)
		lambda->idx[ii] = i->idx[ii];
	


	Index::MultiIdx* alpha;
	alpha = new Index::MultiIdx(i->size-1);
	alpha->setAll(g);
	
	
	
	
	std::vector<Index::MultiIdx*> v0,v;
	std::vector<Index::MultiIdx*>::iterator iter,iter2;

	
	v0 = alpha->getLessEqThan();	
	v = lambda->Index::MultiIdx::selectGreaterEqFrom(v0);


	Index::MultiIdx* sigma;
	
	Domain::TensorPoint* tp;
	
	for(iter=v.begin();iter!=v.end();iter++)
	{
		sigma = (*iter);

		//fprintf(stderr,"\n----\n");
		//fprintf(stderr,"sigma:");
		//sigma->print(stderr);
		//fprintf(stderr,"|");
		//lambda->print(stderr);
		
		coef = Bernstein::XiV2(k,g,sigma,alpha,lambda);
		//fprintf(stderr,"|");
		//fprintf(stderr,"%g\n",coef);
			
			//u->Domain::SimplexPoint::println(stderr);
		tp = Domain::TensorPoint::TfromSimplexPoint(u);
			//tp->Domain::SimploidPoint::print(stderr);
			
			//G->print();
		res = res + coef * Bernstein::evalTensorial(alpha,sigma,tp);	
					
		
	}
	
	
	return res;
}


void Bernstein::setConversionMatrixS2TColumn(Index::MultiIdx *i, Index::IndexedMatrix *m)
{
	
	Rational* Qaux;
	
	double coef;
	int k;
	int ii;

	int g;
	
	g = i->MultiIdx::sum();
	
	
	int row,col;
	
	
	col = m->IndexedMatrix::getCol(i);
	
	
	k = i->size-1;
	
	Index::MultiIdx* lambda;


	lambda = new Index::MultiIdx(i->size-1);
	for(ii=0;ii<lambda->size;ii++)
		lambda->idx[ii] = i->idx[ii];
	


	Index::MultiIdx* alpha;
	alpha = new Index::MultiIdx(i->size-1);
	alpha->setAll(g);
	
	
	
	
	std::vector<Index::MultiIdx*> v0,v;
	std::vector<Index::MultiIdx*>::iterator iter,iter2;

	
	v0 = alpha->getLessEqThan();	
	v = lambda->Index::MultiIdx::selectGreaterEqFrom(v0);


	Index::MultiIdx* sigma;
	
	
	for(iter=v.begin();iter!=v.end();iter++)
	{
		sigma = (*iter);

		//fprintf(stderr,"\n----\n");
		//fprintf(stderr,"sigma:");
		//sigma->print(stderr);
		//fprintf(stderr,"|");
		//lambda->print(stderr);
		
		Qaux = Bernstein::mpXiV2(k,g,sigma,alpha,lambda);
		coef = Qaux->Rational::getDouble();
		delete Qaux;
		//fprintf(stderr,"|");
		//fprintf(stderr,"%g\n",coef);
			
		
		
		
		row = m->IndexedMatrix::getRow(sigma);
		
		
		m->data[row][col] = coef;
		
		
	}
	
	
	return;
}



void Bernstein::setConversionMatrixS2SColumn(Index::MultiIdx *i, Domain::AffineTransformation *T,Index::IndexedMatrix *m)
{
	
	double coef;

	Float *Faux;
	
	
	
	int g;
	
	g = i->MultiIdx::sum();
	
	
	int row,col;
	
	
	col = m->IndexedMatrix::getCol(i);
		
	
	std::vector<Index::MultiIdx*> v;
	std::vector<Index::MultiIdx*>::iterator iter;

	
	v = Index::MultiIdx::MultiIdx::getMultiIdxSet(g,i->size);


	Index::MultiIdx* c;
	
	
	for(iter=v.begin();iter!=v.end();iter++)
	{
		c = (*iter);
		
		Faux = Bernstein::Bernstein::mpPhi(c,i,T);
		coef = Faux->Float::getDouble();
		
		//coef = Bernstein::Bernstein::Phi(c,i,T);
			
		
		
		
		row = m->IndexedMatrix::getRow(c);
		
		
		m->data[row][col] = coef;
		
		
	}
	
	
	return;
}



double Bernstein::evalSimplicialUsingTensor(int g,Index::MultiIdx *i, Domain::SimplexPoint* u)
{
	double res=0;
	double coef;
	int k;
	int ii;
	int hsum;
	
	
	k = i->size -2;
	
	Index::MultiIdx* j;
	j = new Index::MultiIdx(i->size-1);
	for(ii=0;ii<j->size;ii++)
		j->idx[ii] = i->idx[ii];
	
	Index::MultiIdx* G;
	G = new Index::MultiIdx(i->size-1);
	G->setAll(g);
	
	
	
	
	std::vector<Index::MultiIdx*> v0,v,v2,v3;
	std::vector<Index::MultiIdx*>::iterator iter,iter2;

	
	
	v0 = Index::MultiIdx::getMultiIdxSetLessEq(g,j->size);
	v = j->Index::MultiIdx::selectGreaterEqFrom(v0);

	Index::MultiIdx* fmax;
	Index::MultiIdx* f;	
	Index::MultiIdx* h;
	
	Domain::TensorPoint* tp;
	
	for(iter=v.begin();iter!=v.end();iter++)
	{
		h = (*iter);
		//h->print();
		
		hsum = h->sum();
		fmax = (j->add(G))->sub(h);
		//fmax->print();
		
		v3 = fmax->Index::MultiIdx::getLessEqThan();
		v2 = j->Index::MultiIdx::selectGreaterEqFrom(v3);
		for(iter2=v2.begin();iter2!=v2.end();iter2++)
		{
			f = (*iter2);
			//f->print();
			
			coef = Bernstein::Xi(k,g,h,f,j);
			
			
			//u->Domain::SimplexPoint::println(stderr);
			tp = Domain::TensorPoint::TfromSimplexPoint(u);
			//tp->Domain::SimploidPoint::print(stderr);
			
			//G->print();
			res = res + coef * Bernstein::evalTensorial(G,f,tp);	
			
		}
		v3.clear();
		v2.clear();
		
		
		
	}
	
	
	return res;
}


double Bernstein::evalSimplicialUsingSimplicial(int g, Index::MultiIdx* i, Domain::AffineTransformation* T, Domain::SimplexPoint* u)
{
	double res = 0;
	double coef;
	int cfac;

	//T->AffineTransformation::print(stderr);
	Index::MultiIdx* c;
	
	std::vector<Index::MultiIdx*> c_vec;
	std::vector<Index::MultiIdx*>:: iterator c_iter;
	
	std::vector<Index::MatrixIdx*> l_vec;
	std::vector<Index::MatrixIdx*>:: iterator l_iter;
	
	
	c_vec = Index::MultiIdx::getMultiIdxSet(g,i->size);
	
	for(c_iter=c_vec.begin();c_iter!=c_vec.end();c_iter++)
	{
		c = (*c_iter);
		cfac = c->factorial();
		
		l_vec = Index::MatrixIdx::MatrixIdx::getAllIndexes(i,c);
		
		//c->MultiIdx::print(stderr);
		//i->MultiIdx::print(stderr);
		coef = Bernstein::Phi(c,i,T); 
		res = res + coef * Bernstein::evalSimplicial(g,c,u);
		
	}
	
	
	return res;
}


double Bernstein::evalSimplicialUsingSimplicial2(int g, Index::MultiIdx* kappa, Domain::AffineTransformation* T, Domain::SimplexPoint* u)
{
	//Generalization of method "evalSimplicialUsingSimplicial"
	// in a way that allows affine transformation from affine spaces 
	// of different dimensions
	//
	// See report Gluing
	
	double res = 0;
	double coef;


	Index::MultiIdx* mu;
	
	std::vector<Index::MultiIdx*> mu_vec;
	std::vector<Index::MultiIdx*>:: iterator mu_iter;

	mu_vec = Index::MultiIdx::getMultiIdxSet(g,T->origDim+1);
	
	for(mu_iter=mu_vec.begin();mu_iter!=mu_vec.end();mu_iter++)
	{
		mu = (*mu_iter);
		//c->print(stderr);
		//cfac = c->factorial();
		
		//l_vec = Index::MatrixIdx::MatrixIdx::getAllIndexes(i,c);
		
		//c->MultiIdx::print(stderr);
		//i->MultiIdx::print(stderr);
		coef = Bernstein::Phi2(kappa,mu,T); 
		
		res = res + coef * Bernstein::evalSimplicial(g,mu,u);
		
	}
	
	return res;
}



double Bernstein::evalTensorialUsingSimplicial3(Index::MultiIdx* g, Index::MatrixIdx* L,  Domain::SimplexPoint* u,Domain::AffineTransformation **T)
{
	//Generalization of method "evalTensoriallUsingSimplicial"
	// in a way that allows affine transformation from affine spaces 
	// of different dimensions -- not only the "canonical embedding"
	//
	// See report Gluing
	
	
	std::vector<Index::MatrixIdx*> v,v2;
	std::vector<Index::MultiIdx*> vec_nu;
	std::vector<Index::MultiIdx*>::iterator inu;
	
		std::vector<Index::MatrixIdx*>::iterator i,ii;	

		double res=0;
		double aux;
		Index::MatrixIdx *psi,*omega;
		int alpha_sum,alpha_sum_fac;
		
		double phi0,phi1;
		double b0,b1;
		double coef,coef_in;
		int j;
		
		Index::MultiIdx* nu;
		
		
		alpha_sum_fac=1;
		alpha_sum = g->sum();
		
		for(j=alpha_sum;j>1;j--)
			alpha_sum_fac *= j;
		
		
		vec_nu = Index::MultiIdx::getMultiIdxSet(g->sum(),T[0]->origDim+1);
		
		
		for(inu=vec_nu.begin();inu!=vec_nu.end();inu++)
		{
		
			nu = (*inu);
		// first summation
		// over psi
		
		b0 = Bernstein::evalSimplicial(alpha_sum,nu,u);
		//fprintf(stderr,"%g --\n",b0);
		coef = Bernstein::PhiPhi2(g,nu,L,T);
		
		
		res += coef * b0;
	
	}
	return res;
	
}


double Bernstein::evalTensorialUsingSimplicial2(Index::MultiIdx* g, Index::MatrixIdx* L,  Domain::SimplexPoint* u,Domain::AffineTransformation **T)
{
	//Generalization of method "evalTensoriallUsingSimplicial"
	// in a way that allows affine transformation from affine spaces 
	// of different dimensions -- not only the "canonical embedding"
	//
	// See report Gluing
	
	double res = 0;
	double coef;


	int gsum;
	gsum = g->sum();
	
	Index::MultiIdx* nu;
	
	std::vector<Index::MultiIdx*> nu_vec;
	std::vector<Index::MultiIdx*>:: iterator nu_iter;

	nu_vec = Index::MultiIdx::getMultiIdxSet(gsum,T[0]->origDim+1);
	
	for(nu_iter=nu_vec.begin();nu_iter!=nu_vec.end();nu_iter++)
	{
		nu = (*nu_iter);
		//c->print(stderr);
		//cfac = c->factorial();
		
		//l_vec = Index::MatrixIdx::MatrixIdx::getAllIndexes(i,c);
		
		//c->MultiIdx::print(stderr);
		//i->MultiIdx::print(stderr);
		coef = Bernstein::PhiPhi2(g,nu,L,T); 
		
		res = res + coef * Bernstein::evalSimplicial(gsum,nu,u);
		
	}
	
	return res;
}



double Bernstein::evalTensorialUsingSimplicial(Index::MultiIdx* g, Index::MultiIdx* i, Domain::TensorPoint* u)
{
	double res;
	double coef;
	int gsum;
	
	res = 0;
	
	gsum = g->sum();
	
	Index::MultiIdx* c;
	
	std::vector<Index::MultiIdx*> c_vec;
	std::vector<Index::MultiIdx*>:: iterator c_iter;
	
	std::vector<Index::MatrixIdx*> l_vec;
	std::vector<Index::MatrixIdx*>:: iterator l_iter;
	
	
	c_vec = Index::MultiIdx::getMultiIdxSet(gsum,i->size+1);
	
	for(c_iter=c_vec.begin();c_iter!=c_vec.end();c_iter++)
	{
		c = (*c_iter);
		coef = Bernstein::Gamma(g,c,i); 
		res = res + coef * Bernstein::evalSimplicial(gsum,c,u->toSimplexPoint());
		
	}
	
	
	return res;
}


void Bernstein::setConversionMatrixT2SColumn(Index::MultiIdx *i, Index::IndexedMatrix *m, Index::MultiIdx* g )
{
	double coef;
	int gsum;
	
	
	int row,col;
		
	
	
	Rational* mpg;
	
	
		
	col = m->IndexedMatrix::getCol(i);
		
	
	gsum = g->sum();
	
	Index::MultiIdx* c;
	
	std::vector<Index::MultiIdx*> c_vec;
	std::vector<Index::MultiIdx*>:: iterator c_iter;
	
	std::vector<Index::MatrixIdx*> l_vec;
	std::vector<Index::MatrixIdx*>:: iterator l_iter;
	
	
	c_vec = Index::MultiIdx::getMultiIdxSet(gsum,i->size+1);
	
	for(c_iter=c_vec.begin();c_iter!=c_vec.end();c_iter++)
	{
		c = (*c_iter);
		//coef = Bernstein::Gamma(g,c,i); 
		mpg = Bernstein::mpGamma(g,c,i);
		coef = mpg->Rational::getDouble();
		delete mpg;
		
		row = m->IndexedMatrix::getRow(c);
		
		
		m->data[row][col] = coef;
		
	}
		
	return;
}




double Bernstein::evalTensorial(Index::MultiIdx* g, Index::MultiIdx* i, Domain::SimploidPoint* u)
{
	int j;
	double res = 1;
	Index::MultiIdx *iaux;
	
	//g->print();
	
	iaux = new Index::MultiIdx(2);
	
	for(j=0;j<g->size;j++)
	{
		//new simplicial index
		iaux->idx[0]= i->idx[j];
		iaux->idx[1]= g->idx[j] - iaux->idx[0];
		
		
		//iaux->print();
		
		res = res * Bernstein::evalSimplicial(g->idx[j],iaux,u->coord[j]);

	}
	
	return res;
}





double Bernstein::evalTensorial(Index::MultiIdx* g, Index::MatrixIdx* L, Domain::SimploidPoint* u)
{
	return Bernstein::evalTensorial(g,L->getColumn(0),u); 
}



Index::IndexedMatrix *Bernstein::buildMatrixSimplicial2Tensorial(int dim, int deg)
{
	Index::IndexedMatrix* m;
	std::vector<Index::MultiIdx*> vs,vt;
	std::vector<Index::MultiIdx*>::iterator iter;
	
	
	Index::MultiIdx* G;
	G = new Index::MultiIdx(dim);
	G->setAll(deg);
	
	
	vs = Index::MultiIdx::getMultiIdxSet(deg,dim+1);
	vt = G->MultiIdx::getLessEqThan();
	
	m = new Index::IndexedMatrix(vt.size(),vs.size());
	m->IndexedMatrix::buildIndices(Index::MultiIdx::MultiIdx::upcastVector(vt),
									Index::MultiIdx::MultiIdx::upcastVector(vs));
	
	
	for(iter=vs.begin();iter!=vs.end();iter++)
		Bernstein::Bernstein::setConversionMatrixS2TColumn((*iter),m);
	
	//m->print(stderr);
	
	return m;
}



Index::IndexedMatrix *Bernstein::buildMatrixTensorial2Simplicial(int order, int* g )
{
	Index::IndexedMatrix* m;
	std::vector<Index::MultiIdx*> vs,vt;
	std::vector<Index::MultiIdx*>::iterator iter;
	
	int i;

	Index::MultiIdx *gt;
	
	gt = new Index::MultiIdx(order);
		
	int gs;
	
	
	for(i=0;i<order;i++)
		gt->idx[i] = g[i];
	
	gs = gt->sum();
	
	vs = Index::MultiIdx::getMultiIdxSet(gs,order+1);
	
	vt = gt->MultiIdx::getLessEqThan();
	
	m = new Index::IndexedMatrix(vs.size(),vt.size());
	m->IndexedMatrix::buildIndices(Index::MultiIdx::MultiIdx::upcastVector(vs),
									Index::MultiIdx::MultiIdx::upcastVector(vt));
	
	
	for(iter=vt.begin();iter!=vt.end();iter++)
		Bernstein::Bernstein::setConversionMatrixT2SColumn((*iter),m,gt);
	
	//m->print(stderr);
	
	return m;
}



Index::IndexedMatrix *Bernstein::buildMatrixSimplicial2Simplicial(int dim, int deg,Domain::AffineTransformation *T)
{
	Index::IndexedMatrix* m;
	std::vector<Index::MultiIdx*> vs;
	std::vector<Index::MultiIdx*>::iterator iter;
	
	
	
	vs = Index::MultiIdx::getMultiIdxSet(deg,dim+1);
	
	m = new Index::IndexedMatrix(vs.size(),vs.size());
	m->IndexedMatrix::buildIndices(Index::MultiIdx::MultiIdx::upcastVector(vs),
									Index::MultiIdx::MultiIdx::upcastVector(vs));
	
	
	for(iter=vs.begin();iter!=vs.end();iter++)
		Bernstein::Bernstein::setConversionMatrixS2SColumn((*iter),T,m);
	
	//m->print(stderr);
	
	return m;
}





Index::IndexedMPMatrix *Bernstein::buildMPMatrixSimplicial2Tensorial(int dim, int deg)
{
	Index::IndexedMPMatrix* m;
	std::vector<Index::MultiIdx*> vs,vt;
	std::vector<Index::MultiIdx*>::iterator iter;
	
	
	Index::MultiIdx* G;
	G = new Index::MultiIdx(dim);
	G->setAll(deg);
	
	
	vs = Index::MultiIdx::getMultiIdxSet(deg,dim+1);
	vt = G->MultiIdx::getLessEqThan();
	
	m = new Index::IndexedMPMatrix(vt.size(),vs.size());
	m->IndexedMPMatrix::buildIndices(Index::MultiIdx::MultiIdx::upcastVector(vt),
									Index::MultiIdx::MultiIdx::upcastVector(vs));
	
	
	for(iter=vs.begin();iter!=vs.end();iter++)
		Bernstein::Bernstein::setConversionMPMatrixS2TColumn((*iter),m);
	
	//m->print(stderr);
	
	return m;
}



Index::IndexedMPMatrix *Bernstein::buildMPMatrixTensorial2Simplicial(int order, int* g )
{
	Index::IndexedMPMatrix* m;
	std::vector<Index::MultiIdx*> vs,vt;
	std::vector<Index::MultiIdx*>::iterator iter;
	
	int i;

	Index::MultiIdx *gt;
	
	gt = new Index::MultiIdx(order);
		
	int gs;
	
	
	for(i=0;i<order;i++)
		gt->idx[i] = g[i];
	
	gs = gt->sum();
	
	vs = Index::MultiIdx::getMultiIdxSet(gs,order+1);
	
	vt = gt->MultiIdx::getLessEqThan();
	
	m = new Index::IndexedMPMatrix(vs.size(),vt.size());
	m->IndexedMPMatrix::buildIndices(Index::MultiIdx::MultiIdx::upcastVector(vs),
									Index::MultiIdx::MultiIdx::upcastVector(vt));
	
	
	for(iter=vt.begin();iter!=vt.end();iter++)
		Bernstein::Bernstein::setConversionMPMatrixT2SColumn((*iter),m,gt);
	
	//m->print(stderr);
	
	return m;
}



Index::IndexedMPMatrix *Bernstein::buildMPMatrixSimplicial2Simplicial(int dim, int deg,Domain::AffineTransformation *T)
{
	Index::IndexedMPMatrix *m,*mask;
	std::vector<Index::MultiIdx*> vs;
	std::vector<Index::MultiIdx*>::iterator iter;
	
	
	
	vs = Index::MultiIdx::getMultiIdxSet(deg,dim+1);
	
	m = new Index::IndexedMPMatrix(vs.size(),vs.size());
	m->IndexedMPMatrix::buildIndices(Index::MultiIdx::MultiIdx::upcastVector(vs),
									Index::MultiIdx::MultiIdx::upcastVector(vs));
	
	mask = new Index::IndexedMPMatrix(vs.size(),vs.size());
	mask->IndexedMPMatrix::buildIndices(Index::MultiIdx::MultiIdx::upcastVector(vs),
										Index::MultiIdx::MultiIdx::upcastVector(vs));
		
	
	
	
	for(iter=vs.begin();iter!=vs.end();iter++)
		Bernstein::Bernstein::setConversionMPMatrixS2SColumn((*iter),T,m);
	
	//m->print(stderr);
	
	return m;
}






void Bernstein::setConversionMPMatrixT2SColumn(Index::MultiIdx *i, Index::IndexedMPMatrix *m, Index::MultiIdx* g )
{
	double coef;
	int gsum;
	
	
	int row,col;
		
	
	
	Rational* mpg;
	
	
		
	col = m->IndexedMPMatrix::getCol(i);
		
	
	gsum = g->sum();
	
	Index::MultiIdx* c;
	
	std::vector<Index::MultiIdx*> c_vec;
	std::vector<Index::MultiIdx*>:: iterator c_iter;
	
	std::vector<Index::MatrixIdx*> l_vec;
	std::vector<Index::MatrixIdx*>:: iterator l_iter;
	
	
	c_vec = Index::MultiIdx::getMultiIdxSet(gsum,i->size+1);
	
	for(c_iter=c_vec.begin();c_iter!=c_vec.end();c_iter++)
	{
		c = (*c_iter);
		//coef = Bernstein::Gamma(g,c,i); 
		mpg = Bernstein::mpGamma(g,c,i);
		coef = mpg->Rational::getDouble();
		
		row = m->IndexedMPMatrix::getRow(c);
		
		delete m->data[row][col];
		m->data[row][col] = mpg;
		
	}
		
	return;
}



void Bernstein::setConversionMPMatrixS2SColumn(Index::MultiIdx *i, Domain::AffineTransformation *T,Index::IndexedMPMatrix *m)
{
	
	double coef;

	Float *Faux;
	
	
	
	int g;
	
	g = i->MultiIdx::sum();
	
	
	int row,col;
	
	
	col = m->IndexedMPMatrix::getCol(i);
		
	
	std::vector<Index::MultiIdx*> v;
	std::vector<Index::MultiIdx*>::iterator iter;

	
	v = Index::MultiIdx::MultiIdx::getMultiIdxSet(g,i->size);


	Index::MultiIdx* c;
	
	
	for(iter=v.begin();iter!=v.end();iter++)
	{
		c = (*iter);
		
		Faux = Bernstein::Bernstein::mpPhi(c,i,T);
		coef = Faux->Float::getDouble();
		
		//coef = Bernstein::Bernstein::Phi(c,i,T);
			
		
		
		
		row = m->IndexedMPMatrix::getRow(c);
		
		
		delete m->data[row][col];
		m->data[row][col] = Faux;
		
		
	}
	
	
	return;
}




void Bernstein::setConversionMPMatrixS2TColumn(Index::MultiIdx *i, Index::IndexedMPMatrix *m)
{
	
	Rational* Qaux;
	
	double coef;
	int k;
	int ii;

	int g;
	
	g = i->MultiIdx::sum();
	
	
	int row,col;
	
	
	col = m->IndexedMPMatrix::getCol(i);
	
	
	k = i->size-1;
	
	Index::MultiIdx* lambda;


	lambda = new Index::MultiIdx(i->size-1);
	for(ii=0;ii<lambda->size;ii++)
		lambda->idx[ii] = i->idx[ii];
	


	Index::MultiIdx* alpha;
	alpha = new Index::MultiIdx(i->size-1);
	alpha->setAll(g);
	
	
	
	
	std::vector<Index::MultiIdx*> v0,v;
	std::vector<Index::MultiIdx*>::iterator iter,iter2;

	
	v0 = alpha->getLessEqThan();	
	v = lambda->Index::MultiIdx::selectGreaterEqFrom(v0);


	Index::MultiIdx* sigma;
	
	
	for(iter=v.begin();iter!=v.end();iter++)
	{
		sigma = (*iter);

		//fprintf(stderr,"\n----\n");
		//fprintf(stderr,"sigma:");
		//sigma->print(stderr);
		//fprintf(stderr,"|");
		//lambda->print(stderr);
		
		Qaux = Bernstein::mpXiV2(k,g,sigma,alpha,lambda);
		coef = Qaux->Rational::getDouble();
		//delete Qaux;
		//fprintf(stderr,"|");
		//fprintf(stderr,"%g\n",coef);
			
		
		
		
		row = m->IndexedMPMatrix::getRow(sigma);
		sigma->MultiIdx::print(stderr);
		
		delete m->data[row][col];
		m->data[row][col] = Qaux;
		
		
	}
	
	
	return;
}


}
