#ifndef BERNSTEIN_H_
#define BERNSTEIN_H_

#include "../Index/MultiIdx.h"
#include "../Index/MatrixIdx.h"
#include "../Domain/SimploidPoint.h"
#include "../Domain/TensorPoint.h"
#include "../Domain/SimplexPoint.h"
#include "../Domain/AffineTransformation.h"
#include "math.h"
#include<vector>
#include<stdio.h>

#include <gmp.h>

#include "../Index/IndexedMatrix.h"
#include "../Index/IndexedMPMatrix.h"

//#include "MultiIndexLinearEquation.h"


#include "../Numbers/Rational.h"
#include "../Numbers/Integer.h"




namespace MathFunction
{

class Bernstein
{
public:
	int dum;
	
	
	Bernstein(int d);
	virtual ~Bernstein();
	
	static void  setConversionMatrixS2TColumn(Index::MultiIdx *i, Index::IndexedMatrix *m);
	static void  setConversionMatrixS2SColumn(Index::MultiIdx *i, Domain::AffineTransformation *T,Index::IndexedMatrix *m);
	static void  setConversionMatrixT2SColumn(Index::MultiIdx *i, Index::IndexedMatrix *m,
														Index::MultiIdx* gt );
	
	
	//static MultiIndexLinearEquation*  eqTensor2Simplicial(int g,Index::MultiIdx *i);
	
	static double  Xi(int k, int g, Index::MultiIdx* h, Index::MultiIdx* f, Index::MultiIdx* j);
	
	static double  evalSimplicial2(int g, Index::MultiIdx *i, Domain::SimplexPoint* u);
	static double  evalSimplicial(int g, Index::MultiIdx *i, Domain::SimplexPoint* u);
	static double  evalTensorial(Index::MultiIdx* g, Index::MultiIdx* i, Domain::SimploidPoint* u);
	static double  evalTensorial(Index::MultiIdx* g, Index::MatrixIdx* L, Domain::SimploidPoint* u);
	static double  evalSimplicialDegElev(int g, Index::MultiIdx *i, 
			int newg, Domain::SimplexPoint* u);
	
	static double  evalSimplicialUsingTensor(int g, Index::MultiIdx *i, Domain::SimplexPoint* u);

	static double  evalSimplicialUsingTensorV2(int g, Index::MultiIdx *i, Domain::SimplexPoint* u);

	static double  evalSimplicialUsingSimplicial(int g, Index::MultiIdx* i, Domain::AffineTransformation* T, Domain::SimplexPoint* u);
	static double  evalSimplicialUsingSimplicial2(int g, Index::MultiIdx* i, Domain::AffineTransformation* T, Domain::SimplexPoint* u);
	static double  evalTensorialUsingSimplicial3(Index::MultiIdx* g, Index::MatrixIdx* L,  Domain::SimplexPoint* u,Domain::AffineTransformation **T);
	
	static double  evalTensorialUsingSimplicial(Index::MultiIdx* g, Index::MultiIdx* i, Domain::TensorPoint* u);
	
	static double  evalTensorialUsingSimplicial2(Index::MultiIdx* g, Index::MatrixIdx* L, Domain::SimplexPoint* u,Domain::AffineTransformation **T);
	//Auxiliary functions
	static double  PhiPhi2(Index::MultiIdx* alpha, Index::MultiIdx* nu, Index::MatrixIdx *L, Domain::AffineTransformation **T);
	static double  Phi2(Index::MultiIdx* c, Index::MultiIdx* i, Domain::AffineTransformation *T);
	static double  Phi(Index::MultiIdx* c, Index::MultiIdx* i, Domain::AffineTransformation *T);
	static Float*  mpPhi(Index::MultiIdx* c, Index::MultiIdx* i, Domain::AffineTransformation *T);
	static double  Gamma(Index::MultiIdx* r, Index::MultiIdx* c, Index::MultiIdx* diag );
	static Rational*  mpGamma(Index::MultiIdx* r, Index::MultiIdx* c, Index::MultiIdx* diag );
	static double  Psi(Index::MultiIdx* g, Index::MatrixIdx* m);
	static Rational*  mpPsi(Index::MultiIdx* g, Index::MatrixIdx* m);
	static double  XiV2(int d, int g, Index::MultiIdx* sigma, Index::MultiIdx* alpha, Index::MultiIdx* lambda);
	static Rational*  mpXiV2(int d, int g, Index::MultiIdx* sigma, Index::MultiIdx* alpha, Index::MultiIdx* lambda);

	
	static Index::IndexedMatrix*  buildMatrixSimplicial2Tensorial(int dim, int deg);
	static Index::IndexedMatrix * buildMatrixTensorial2Simplicial(int dim, int* g);
	static Index::IndexedMatrix * buildMatrixSimplicial2Simplicial(int dim, int deg, Domain::AffineTransformation *T);

	
	
	
	//Multi-precision routines
	static Index::IndexedMPMatrix*  buildMPMatrixSimplicial2Tensorial(int dim, int deg);
	static Index::IndexedMPMatrix * buildMPMatrixTensorial2Simplicial(int dim, int* g);
	static Index::IndexedMPMatrix * buildMPMatrixSimplicial2Simplicial(int dim, int deg, Domain::AffineTransformation *T);
	
	static void  setConversionMPMatrixS2TColumn(Index::MultiIdx *i, Index::IndexedMPMatrix *m);
	static void  setConversionMPMatrixS2SColumn(Index::MultiIdx *i, Domain::AffineTransformation *T,Index::IndexedMPMatrix *m);
	static void  setConversionMPMatrixT2SColumn(Index::MultiIdx *i, Index::IndexedMPMatrix *m,
														Index::MultiIdx* gt );
};

}

#endif /*BERNSTEIN_H_*/
