#include <Numbers/Float.h>


double Float::getDouble()
{
	
	return mpf_get_d(this->value);
}


Float::Float(double d)
{
	mpf_init(this->value);
	mpf_set_d(this->value,d);

}

Float::Float(mpf_t fv)
{
	mpf_init(this->value);
	mpf_set(this->value,fv);

}


Float* Float::ipow(double base, int exp)
{
	int uexp;
	Float *res;
	
	
	mpf_t f,faux;
	mpf_t r;
	mpf_t b;
		
	if(exp<0)
		uexp = -1*(exp);
	else
		uexp = exp;

	mpf_init(f);
	mpf_init(faux);
		
	mpf_init(r);
	mpf_init(b);
		
	mpf_set_d(b,base);
	
	mpf_pow_ui(r,b,(unsigned long int)uexp);
	
	mpf_set_si(f,(signed long int)1);
	
	
	if(exp<0)
		mpf_div(faux,f,r);
	else
		mpf_set(faux,r);
	
	
	
	res = new Float(faux);
	
	mpf_clear(f);
	mpf_clear(r);
	mpf_clear(b);
	mpf_clear(faux);
	
	return res;
	
	
	
}


void Float::mul_(Float*  op)
{
	mpf_t aux;
	mpf_init(aux);
	mpf_set(aux,this->value);

	mpf_mul(this->value,aux,op->value);
	mpf_clear(aux);

	return;
}

void Float::div_(Float*  op)
{
	mpf_t aux;
	mpf_init(aux);
	mpf_set(aux,this->value);

	mpf_div(this->value,aux,op->value);
	mpf_clear(aux);

	return;
}

void Float::add_(Float*  op)
{
	mpf_t aux;
	mpf_init(aux);
	mpf_set(aux,this->value);

	mpf_add(this->value,aux,op->value);
	mpf_clear(aux);

	return;
}

void Float::sub_(Float*  op)
{
	mpf_t aux;
	mpf_init(aux);
	mpf_set(aux,this->value);

	mpf_sub(this->value,aux,op->value);
	mpf_clear(aux);

	return;
}

void Float::mul_(Rational*  op)
{
	mpf_t aux;
	mpf_t opaux;
	
	mpf_init(aux);
	mpf_set(aux,this->value);

	mpf_init(opaux);
	mpf_set_q(opaux,op->value);

	
	mpf_mul(this->value,aux,opaux);
	mpf_clear(aux);

	return;
}

void Float::div_(Rational*  op)
{
	mpf_t aux;
	mpf_t opaux;
	
	mpf_init(aux);
	mpf_set(aux,this->value);

	mpf_init(opaux);
	mpf_set_q(opaux,op->value);

	
	mpf_div(this->value,aux,opaux);
	mpf_clear(aux);

	return;
}

void Float::add_(Rational*  op)
{
	mpf_t aux;
	mpf_t opaux;
	
	mpf_init(aux);
	mpf_set(aux,this->value);

	mpf_init(opaux);
	mpf_set_q(opaux,op->value);

	
	mpf_add(this->value,aux,opaux);
	mpf_clear(aux);

	return;
}


void Float::sub_(Rational*  op)
{
	mpf_t aux;
	mpf_t opaux;
	
	mpf_init(aux);
	mpf_set(aux,this->value);

	mpf_init(opaux);
	mpf_set_q(opaux,op->value);

	
	mpf_sub(this->value,aux,opaux);
	mpf_clear(aux);

	return;
}


void Float::mul_(Integer*  op)
{
	mpf_t aux;
	mpf_t opaux;
	
	mpf_init(aux);
	mpf_set(aux,this->value);

	mpf_init(opaux);
	mpf_set_z(opaux,op->value);

	
	mpf_mul(this->value,aux,opaux);
	mpf_clear(aux);

	return;
}

void Float::div_(Integer*  op)
{
	mpf_t aux;
	mpf_t opaux;
	
	mpf_init(aux);
	mpf_set(aux,this->value);

	mpf_init(opaux);
	mpf_set_z(opaux,op->value);

	
	mpf_div(this->value,aux,opaux);
	mpf_clear(aux);

	return;
}

void Float::add_(Integer*  op)
{
	mpf_t aux;
	mpf_t opaux;
	
	mpf_init(aux);
	mpf_set(aux,this->value);

	mpf_init(opaux);
	mpf_set_z(opaux,op->value);

	
	mpf_add(this->value,aux,opaux);
	mpf_clear(aux);

	return;
}


void Float::sub_(Integer*  op)
{
	mpf_t aux;
	mpf_t opaux;
	
	mpf_init(aux);
	mpf_set(aux,this->value);

	mpf_init(opaux);
	mpf_set_z(opaux,op->value);

	
	mpf_sub(this->value,aux,opaux);
	mpf_clear(aux);

	return;
}



Float::~Float()
{
}
