#ifndef FLOAT_H_
#define FLOAT_H_

#include <gmp.h>
#include "Rational.h"


class Float : public Number
{
	
public:
	
	mpf_t value;
	
	
	Float(double d);
	Float(mpf_t fv);	
		
	double  getDouble();
			
	Float*  mul(Float*  op);
	Float*  sub(Float*  op);
	Float*  add(Float*  op);
	Float*  div(Float*  op);
	
	void  mul_(Float*  op);
	void  sub_(Float*  op);
	void  add_(Float*  op);
	void  div_(Float*  op);
	
	
	void  mul_(Rational*  op);
	void  sub_(Rational*  op);
	void  add_(Rational*  op);
	void  div_(Rational*  op);
		
	void  mul_(Integer*  op);
	void  sub_(Integer*  op);
	void  add_(Integer*  op);
	void  div_(Integer*  op);
	
	static Float*  ipow(double  base, int exp);
	
	static Float*  factorial(int i);
	
	

	virtual ~Float();
};

#endif /*FLOAT_H_*/
