#include "Integer.h"


Integer::Integer(mpz_t v)
{
	mpz_init(this->value);
	mpz_set(this->value,v);
}


Integer::Integer(int i)
{
	mpz_init(this->value);
	mpz_set_si(this->value,(signed long int)i);
	
}


Integer* Integer::factorial(int i)
{
	
	mpz_t fac;
	mpz_init(fac);
		
	mpz_fac_ui(fac,(unsigned long int)i);
	
	return new Integer(fac);
}


Integer* Integer::combination(int n, int k)
{
	Integer* res;
	
	mpz_t comb;
	mpz_init(comb);
	
	mpz_bin_uiui(comb,(unsigned long int)n, (unsigned long int)k);
	
	res = new Integer(comb);
	
	mpz_clear(comb);
	
	return res;
	
	
	
}

Integer* Integer::combination(Integer* n,int k)
{
	Integer* res;
	
	mpz_t comb;
	mpz_init(comb);
	
	mpz_bin_ui(comb,n->value, (unsigned long int)k);
	
	res = new Integer(comb);
	
	mpz_clear(comb);
	
	return res;
	
	
	
}







Integer* Integer::add(Integer*  op)
{
	mpz_t sum;
	mpz_init(sum);
		
	mpz_add(sum,this->value,op->value);
	
	return new Integer(sum);
}

Integer* Integer::sub(Integer*  op)
{
	mpz_t sum;
	mpz_init(sum);
		
	mpz_sub(sum,this->value,op->value);
	
	return new Integer(sum);
}

Integer* Integer::mul(Integer*  op)
{
	mpz_t sum;
	mpz_init(sum);
		
	mpz_mul(sum,this->value,op->value);
	
	return new Integer(sum);
}













Integer::~Integer()
{
	mpz_clear(this->value);
}
