#ifndef INTEGER_H_
#define INTEGER_H_

#include "Number.h"
#include <gmp.h>


class Integer : public Number 
{
public:
	mpz_t value;
	
	Integer(mpz_t v);
	Integer(int i);
	
	static Integer* factorial(int i);
	static Integer* combination(int n, int k);
	static Integer* combination(Integer* n,int k);
	
	Integer* mul(Integer*  op);
	Integer* sub(Integer*  op);
	Integer* add(Integer*  op);
	
	
	
	virtual ~Integer();
};

#endif /*INTEGER_H_*/
