#include "Rational.h"

Rational* Rational::factorial(int i)
{
	Integer* iaux;
	Rational *Q;
	
	iaux = Integer::Integer::factorial(i);
	
	Q = new Rational(iaux);
	delete iaux;
	
	return Q;
	
	
}

Rational* Rational::ipow(int  base, int exp)
{
	int uexp;
	
	mpq_t q,qaux;
	mpz_t r;
	mpz_t b;
		
	if(exp<0)
		uexp = -1*(exp);
	else
		uexp = exp;

	mpq_init(q);
	mpq_init(qaux);
		
	mpz_init(r);
	mpz_init(b);
		
	mpz_set_si(b,(signed long int)base);
	
	mpz_pow_ui(r,b,(unsigned long int)uexp);
	
	mpq_set_z(q,r);
	
	if(exp<0)
		mpq_inv(qaux,q);
	else
		mpq_set(qaux,q);
	
	
	mpq_clear(q);
	mpz_clear(r);
	mpz_clear(b);
	
	return new Rational(qaux);
	
	
	
}




void Rational::simplify()
{
	mpq_canonicalize(this->value);
}


double Rational::getDouble()
{
	return mpq_get_d(this->value);
}


Rational::Rational(Integer* num)
{
	mpq_init(this->value);

	mpq_set_z(this->value,num->value);
	
	this->Rational::simplify();
}

Rational::Rational(Integer* num, Integer* den)
{
	mpq_init(this->value);
	
	mpq_t n,d;
	mpq_init(n);
	mpq_init(d);
	
	mpq_set_z(n,num->value);
	mpq_set_z(d,den->value);
	
	mpq_div(this->value,n,d);
	
	mpq_clear(n);
	mpq_clear(d);
	
	this->Rational::simplify();
}

Rational::Rational(int num, int den)
{
	mpq_init(this->value);
	
	
	mpq_set_si(this->value,(signed long int)num,(signed long int)den);
	this->Rational::simplify();
	
}

Rational::Rational(mpq_t v)
{
	mpq_init(this->value);
	
	mpq_set(this->value,v);
	this->Rational::simplify();
}




Rational* Rational::add(Rational*  op)
{
	mpq_t sum;
	mpq_init(sum);
		
	mpq_add(sum,this->value,op->value);
	
	return new Rational(sum);
}

Rational* Rational::sub(Rational*  op)
{
	mpq_t sum;
	mpq_init(sum);
		
	mpq_sub(sum,this->value,op->value);
	
	return new Rational(sum);
}

Rational* Rational::mul(Rational*  op)
{
	mpq_t sum;
	mpq_init(sum);
		
	mpq_mul(sum,this->value,op->value);
	
	return new Rational(sum);
}

Rational* Rational::div(Rational*  op)
{
	mpq_t sum;
	mpq_init(sum);
		
	mpq_div(sum,this->value,op->value);
	
	return new Rational(sum);
}


void Rational::div_(Rational*  op)
{
	mpq_t aux;
	mpq_init(aux);
	mpq_set(aux,this->value);
	
	mpq_div(this->value,aux,op->value);
	mpq_clear(aux);
	
	return;
}

void Rational::mul_(Rational*  op)
{
	mpq_t aux;
	mpq_init(aux);
	mpq_set(aux,this->value);
	
	mpq_mul(this->value,aux,op->value);
	mpq_clear(aux);
	
	return;
}


void Rational::add_(Rational*  op)
{
	mpq_t aux;
	mpq_init(aux);
	mpq_set(aux,this->value);
	
	mpq_add(this->value,aux,op->value);
	mpq_clear(aux);
	
	return;
}

void Rational::sub_(Rational*  op)
{
	mpq_t aux;
	mpq_init(aux);
	mpq_set(aux,this->value);
	
	mpq_sub(this->value,aux,op->value);
	mpq_clear(aux);
	
	return;
}





Rational::~Rational()
{
	mpq_clear(this->value);
}
