#ifndef RATIONAL_H_
#define RATIONAL_H_

#include "Integer.h"
#include <gmp.h>

class Rational :public Number
{
public:
	mpq_t value;
	
	Rational(Integer* num);
	Rational(Integer* num, Integer* den);
	Rational(int num, int den);
	Rational(mpq_t v);
	
	
	double getDouble();
	
	void simplify();
	
	Rational* mul(Rational*  op);
	Rational* sub(Rational*  op);
	Rational* add(Rational*  op);
	Rational* div(Rational*  op);
	void mul_(Rational*  op);
	void sub_(Rational*  op);
	void add_(Rational*  op);
	void div_(Rational*  op);
	
	static Rational* ipow(int  base, int exp);
	static Rational* factorial(int i);
	
	
	virtual ~Rational();
};

#endif /*RATIONAL_H_*/
