#ifndef MATRIXINDEX_H_
#define MATRIXINDEX_H_


#include "HyperIndex.h"
#include "../dataType/Integer.h"

class MatrixIndex : public HyperIndex
{
	
public:
	int n_cols;
		
	MultiIndex *col_sum;
	
public:
	virtual ~MatrixIndex();
	
	
	
	

	MultiIndex*  getColumn(int col);
	static Integer*  combination(MatrixIndex* a, MatrixIndex* b);
	MatrixIndex*  clone();
	 MatrixIndex(int rows, int cols);

	MultiIndex*  getColumnMultiIndex();
	MultiIndex*  getDiagonal();
	
	
	static std::vector<MatrixIndex*>  getAllIndexes(MultiIndex* r,MultiIndex* c, MultiIndex* diag);
	static std::vector<MatrixIndex*>  getAllIndexes(MultiIndex* r,MultiIndex* c);
	static std::vector<MatrixIndex*>  getAllIndexes(MultiIndex* r,int n_cols);
	static MatrixIndex*  fromStar(MultiIndex* a, MultiIndex* b);
	static MatrixIndex*  fromHyperIndex(HyperIndex* hi);
	
	void  print(FILE* fp);
	
	bool  isGreaterEqThan(MatrixIndex *op );
	
	
	
	
	
	
};

#endif /*MATRIXINDEX_H_*/
