#include "MultiIndex.h"
#include<stdlib.h>


Integer* MultiIndex::factorial()
{
	int i;
	Integer* f;
	Integer* tmp01I;
	Integer* tmp02I;

	f = Integer::factorial(this->mIdx[0]);
	for(i=1;i<=this->dim;i++)
	{
		tmp02I = Integer::factorial(this->mIdx[i]);
		tmp01I=f;
		f = tmp01I->times(tmp02I);
		delete tmp01I;
		delete tmp02I;
	}

	return f;
}

int MultiIndex::max()
{
	int i;
	int max=-999;

	for(i=0;i<=this->dim;i++)
		if(max<this->mIdx[i])
			max = this->mIdx[i];

	return max;

}

int MultiIndex::sum()
{
	int i;
	int sum=0;

	for(i=0;i<=this->dim;i++)
		sum = sum + this->mIdx[i];

	return sum;

}

void MultiIndex::setAll(int v)
{
	int i;

	for(i=0;i<=this->dim;i++)
		this->mIdx[i] = v;

	return;

}

MultiIndex* MultiIndex::addPrefix(int p)
{
	return this->insertElement(0,p);
}


bool MultiIndex::isCompatible(MultiIndex* op)
{
	return((this->dim + this->sum())==(op->dim + op->sum()));
}



MultiIndex* MultiIndex::append(MultiIndex* op)
{
	MultiIndex* newM = new MultiIndex(this->dim + op->dim+1);
	int i;
	for(i=0;i<=this->dim;i++)
		newM->mIdx[i] = this->mIdx[i];

	for(i=0;i<=op->dim;i++)
			newM->mIdx[i+this->dim+1] = op->mIdx[i];


	return newM;
}

MultiIndex* MultiIndex::sub(MultiIndex* op)
{
	MultiIndex* newM = new MultiIndex(this->dim);
	int i;
	for(i=0;i<=newM->dim;i++)
		newM->mIdx[i] = this->mIdx[i] - op->mIdx[i];

	return newM;
}



MultiIndex* MultiIndex::add(MultiIndex* op)
{
	MultiIndex* newM = new MultiIndex(this->dim);
	int i;
	for(i=0;i<=newM->dim;i++)
		newM->mIdx[i] = this->mIdx[i] + op->mIdx[i];

	return newM;
}

MultiIndex* MultiIndex::supressFirst()
{
	MultiIndex* newM = new MultiIndex(this->dim-1);
	int i;
	for(i=0;i<=newM->dim;i++)
		newM->mIdx[i] = this->mIdx[i+1];

	return newM;
}

MultiIndex* MultiIndex::supressLast()
{
	MultiIndex* newM = new MultiIndex(this->dim-1);
	int i;
	for(i=0;i<=newM->dim;i++)
		newM->mIdx[i] = this->mIdx[i];

	return newM;
}


bool MultiIndex::isGreaterThan(MultiIndex* op)
{
	if(this->dim!=op->dim)
		return false;

	int i;
	for(i=0;i<=this->dim;i++)
		if(this->mIdx[i]<=op->mIdx[i])
			return false;

	return true;
}

bool MultiIndex::isGreaterEqThan(MultiIndex* op)
{
	if(this->dim!=op->dim)
		return false;

	int i;
	for(i=0;i<=this->dim;i++)
		if(this->mIdx[i]<op->mIdx[i])
			return false;

	return true;
}

bool MultiIndex::isLessThan(MultiIndex* op)
{
	if(this->dim!=op->dim)
		return false;

	int i;
	for(i=0;i<=this->dim;i++)
		if(this->mIdx[i]>=op->mIdx[i])
			return false;

	return true;
}

bool MultiIndex::isLessEqThan(MultiIndex* op)
{
	if(this->dim!=op->dim)
		return false;

	int i;
	for(i=0;i<=this->dim;i++)
		if(this->mIdx[i]>op->mIdx[i])
			return false;

	return true;
}


MultiIndex::MultiIndex(int dim)
{
	this->dim = dim;
	this->mIdx = (int* )calloc(dim+1,sizeof(int));
}

MultiIndex::MultiIndex(int dim,int set_all_values_to)
{
	this->dim = dim;
	this->mIdx = (int* )calloc(dim+1,sizeof(int));
	int i;
	for(i=0;i<=dim;i++)
		this->mIdx[i] = set_all_values_to;
}


MultiIndex::~MultiIndex()
{
}

bool MultiIndex::equals(MultiIndex* op)
{
	if(this->dim!=op->dim)
		return false;

	int i;
	for(i=0;i<=this->dim;i++)
		if(this->mIdx[i]!=op->mIdx[i])
			return false;

	return true;
}

MultiIndex* MultiIndex::getSubIndex(int subDim,int* subIdx)
{
	MultiIndex* subIndex = new MultiIndex(subDim);

	int i;

	for(i=0;i<=subDim;i++)
		subIndex->mIdx[i]=this->mIdx[subIdx[i]];

	return subIndex;
}
MultiIndex* MultiIndex::insertElement(int pos,int el)
{
	MultiIndex* newm = new MultiIndex(this->dim+1);

	int i;
	for(i=0;i<pos;i++)
		newm->mIdx[i] = this->mIdx[i];
	newm->mIdx[pos] = el;

	for(i=pos+1;i<this->dim+2;i++)
		newm->mIdx[i] = this->mIdx[i-1];

	return newm;

}

MultiIndex* MultiIndex::clone()
{
	MultiIndex* newm = new MultiIndex(this->dim);

	int i;
	for(i=0;i<=this->dim;i++)
		newm->mIdx[i] = this->mIdx[i];

	return newm;

}

void MultiIndex::print(FILE* fp)
{
	int i;
	fprintf(fp,"\n[");
	for(i=0;i<=this->dim;i++)
		fprintf(fp,"%d,",this->mIdx[i]);
	fprintf(fp,"]\n");
}

char* MultiIndex::toString()
{
	int i;
	char* str = (char*) malloc(100*sizeof(char));
	str[0]='\0';
	char aux[10];

	for(i=0;i<=this->dim;i++)
	{
		sprintf(aux,"_%d",this->mIdx[i]);
		sprintf(str,"%s%s",str,aux);
	}



	return str;
}


//-----------------------

std::vector<MultiIndex*>  MultiIndex::addPrefix(int p, std::vector<MultiIndex*> v,std::vector<MultiIndex*> acum)
{
	std::vector<MultiIndex*>::iterator iter;
	for(iter=v.begin();iter!=v.end();iter++)
		acum.push_back(     ((MultiIndex*)(*iter))->addPrefix(p)        );

	return acum;
}



std::vector<MultiIndex*> MultiIndex::getLessThan()
{
	int i,j;
	std::vector<MultiIndex*> v;
	std::vector<MultiIndex*> acum;


	for(j=0;j<this->mIdx[this->dim];j++)
	{
		v.push_back(new MultiIndex(0,j));
	}



	for(i=this->dim-1;i>=0;i--)
	{
		for(j=0;j<this->mIdx[i];j++)
		{

			acum = MultiIndex::addPrefix(j,v,acum);

		}
		v = acum;
		acum.clear();

	}


	return v;

}

std::vector<MultiIndex*> MultiIndex::getLessEqThan()
{
	int i,j;
	std::vector<MultiIndex*> v,acum;


	for(j=0;j<=this->mIdx[this->dim];j++)
	{
		v.push_back( new MultiIndex(0,j));
	}



	for(i=this->dim-1;i>=0;i--)
	{
		for(j=0;j<=this->mIdx[i];j++)
		{

			acum = MultiIndex::addPrefix(j,v,acum);

		}
		v = acum;
		acum.clear();

	}


	return v;

}



std::vector<MultiIndex*> MultiIndex::selectGreaterFrom(std::vector<MultiIndex*> v)
{
	std::vector<MultiIndex*> acum;
	std::vector<MultiIndex*>::iterator iter;

	for(iter=v.begin();iter!=v.end();iter++)
		if( (*iter)->isGreaterThan(this)  )
			acum.push_back((*iter));


	return acum;
}

std::vector<MultiIndex*> MultiIndex::selectGreaterEqFrom(std::vector<MultiIndex*> v)
{
	std::vector<MultiIndex*> acum;
	std::vector<MultiIndex*>::iterator iter;

	for(iter=v.begin();iter!=v.end();iter++)
		if( (*iter)->isGreaterEqThan(this)  )
			acum.push_back((*iter));


	return acum;
}

std::vector<MultiIndex*> MultiIndex::selectLessFrom(std::vector<MultiIndex*> v)
{
	std::vector<MultiIndex*> acum;
	std::vector<MultiIndex*>::iterator iter;

	for(iter=v.begin();iter!=v.end();iter++)
		if( (*iter)->isLessThan(this)  )
			acum.push_back((*iter));


	return acum;
}

std::vector<MultiIndex*> MultiIndex::selectLessEqFrom(std::vector<MultiIndex*> v)
{
	std::vector<MultiIndex*> acum;
	std::vector<MultiIndex*>::iterator iter;

	for(iter=v.begin();iter!=v.end();iter++)
		if( (*iter)->isLessEqThan(this)  )
			acum.push_back((*iter));


	return acum;
}


std::vector<MultiIndex*> MultiIndex::getMultiIdxSet(int sum,int dim)
{
	std::vector<MultiIndex*> v,res;
	std::vector<MultiIndex*>::iterator iter;


	MultiIndex* top = new MultiIndex(dim);
	top->setAll(sum+1);

	v = top->getLessThan();

	for(iter=v.begin();iter!=v.end();iter++)
			if( (*iter)->sum() == sum  )
				res.push_back((*iter));

	return res;

}


std::vector<MultiIndex*> MultiIndex::getMultiIdxSetLessEq(int sum,int dim)
{
	std::vector<MultiIndex*> v,res;
	std::vector<MultiIndex*>::iterator iter;


	MultiIndex* top = new MultiIndex(dim);
	top->setAll(sum+1);

	v = top->getLessThan();

	for(iter=v.begin();iter!=v.end();iter++)
			if( (*iter)->sum() <= sum  )
				res.push_back((*iter));

	return res;

}


Integer* MultiIndex::combination(MultiIndex* n, MultiIndex* k)
{
	MultiIndex *aux;
	Integer* tmp01I;
	Integer* tmp02I;
	Integer* tmp03I;
	Integer* tmp04I;
	Integer* c;

	aux = n->sub(k);

	tmp01I = n->factorial();
	tmp02I = aux->factorial();
	tmp03I = k->factorial();

	tmp04I = tmp02I->times(tmp03I);
	c = tmp01I->div(tmp04I);


	delete tmp01I;
	delete tmp02I;
	delete tmp03I;
	delete tmp04I;


	return  c;
}

