#include "dataStruct/MultiIndex.h"
#include "dataStruct/HyperIndex.h"
#include "dataStruct/MatrixIndex.h"

#include "mathFunctions/Bernstein.h"

#include "domain_and_range/DomainPoint.h"
#include "domain_and_range/DomainMapping.h"
#include "dataType/IrregularMatrix.h"
#include "dataType/Number.h"
#include <stdio.h>
#include <stdlib.h>
#include <vector>

int main()
{

	/// --------------Plotting Univariate Bernstein Basis --------------------
	FILE* fp;
	FILE *fpscript;

	int fcount;
	char *mI_str;
	char f_pref[100] = "UniBernst";
	char sname[100] = "UniBernst_script.p";
	char dirname[100] = "/home/lbfreitas/tese_out/";
	char fname[100];
	fprintf(stderr,"start:\n");

	int uni_deg=3;

	sprintf(fname,"%s%s",dirname,sname);
	fpscript = fopen(fname,"w");
	fprintf(fpscript,"plot ");

	MultiIndex* d0 = new MultiIndex(0,1);
	std::vector<DomainPoint*> v_d0;
	std::vector<DomainPoint*>::iterator iter;

	//Adelta
	v_d0 = DomainPoint::domainPoints(d0,50);
	DomainPoint* U_d0;


	// B^alpha_Lambda(U_d0)
	MultiIndex* alpha = new MultiIndex(0,uni_deg);
	MultiIndex* kappa;
	HyperIndex* Lambda = new HyperIndex(d0);


	std::vector<MultiIndex*> k_v;
	std::vector<MultiIndex*>::iterator k_v_iter;

	k_v = MultiIndex::getMultiIdxSet(uni_deg,1);

	Number* BV;

	for(k_v_iter=k_v.begin();k_v_iter!=k_v.end();k_v_iter++)
	{

		kappa = (*k_v_iter);
		mI_str = kappa->toString();

		sprintf(fname,"%s%s%s",dirname,f_pref,mI_str);

		fp = fopen(fname,"w");

		fprintf(fpscript,"\"%s%s\" with line,",f_pref,mI_str);

		free(mI_str);

		Lambda->line[0] = kappa->clone();




		for(iter=v_d0.begin();iter!=v_d0.end();iter++)
		{
			U_d0 = (DomainPoint*)(*iter);


			BV = Bernstein::eval(alpha, Lambda,U_d0);


			U_d0->printPlot(BV,fp);


		}


		fclose(fp);

	}

	fseek(fpscript,-1L,SEEK_END);
	fprintf(fpscript,";");
	fclose(fpscript);


	/*
	MultiIndex* delta = new MultiIndex(1,1);
	MultiIndex* epsilon = new MultiIndex(1,1);

	std::vector<DomainPoint*> v_delta,v_epsilon;
	std::vector<DomainPoint*>::iterator iter;

	//Adelta
	v_delta = DomainPoint::domainPoints(delta,50);
	v_epsilon = DomainPoint::domainPoints(epsilon,50);
	DomainPoint* U_delta;
	DomainPoint* U_epsilon;


	DomainMapping *DM = DomainMapping::example04();
	DM->allocateIM();
	DM->buildIM_matrices();



	// B^alpha_Lambda(U_epsilon = Gamma(U_delta))
	MultiIndex* alpha = new MultiIndex(1,3);
	MultiIndex* kappa = new MultiIndex(1);
	kappa->mIdx[0]=1;
	kappa->mIdx[1]=2;

	HyperIndex* Lambda = new HyperIndex(epsilon);
	Lambda->line[0] = kappa->clone();
	kappa->mIdx[0]=2;
	kappa->mIdx[1]=1;
	Lambda->line[1] = kappa->clone();




	Number* BU_usingDM;
	Number* BV;

	Bernstein* Bern = new Bernstein();

	Bern->precompute_composition_Adelta_to_Aepsilon(alpha, delta, epsilon,Lambda,DM);
	//Bern->precompute_composition_Adelta_to_Ad(3,kappa,mdim,2,DM);

	for(iter=v_delta.begin();iter!=v_delta.end();iter++)
	{
		U_delta = (DomainPoint*)(*iter);

		U_epsilon = DM->map_A_delta_to_A_epsilon_usingIM(U_delta);


		BV = Bernstein::eval(alpha, Lambda,U_epsilon);

		BU_usingDM = Bern->eval_summation_over_precomputed_indices_and_coefs(U_delta);


		U_epsilon->printPlot(BU_usingDM,fp1);
		//U_epsilon->printPlot(BV,fp2);



	}
	for(iter=v_epsilon.begin();iter!=v_epsilon.end();iter++)
	{
		U_epsilon = (DomainPoint*)(*iter);


		BV = Bernstein::eval(alpha, Lambda,U_epsilon);

		U_epsilon->printPlot(BV,fp2);


	}

	*/



	fprintf(stderr,"\ndone!\n");
}
