#include "BlockType.h"


BlockType* BlockType::example01()
{
	BlockType* bt = new BlockType();
	
	bt->blockTypeId=1;
	
	bt->domainType = DomainType::getTriangularDomain();
	
	
	//representing x,y and velocity
	bt->rangeDimension = 3;
	bt->mdeg = (MultiIndex**) malloc(3*sizeof(MultiIndex*));
	
	//the same degree for x,y and velocity
	bt->mdeg[0] = new MultiIndex(0,3);
	bt->mdeg[1] = new MultiIndex(0,3);
	bt->mdeg[2] = new MultiIndex(0,3);
	
	// 30 internal variables
	bt->nIntVars = 30;
	
	// 22 external variables
	bt->nExtVars = 22;
	
	bt->m = new Matrix(bt->nIntVars,bt->nExtVars);
	bt->m->allocate_and_zero();
	
	// building the matrix
	int i;
	
	Number* n1 = Number::getUnitary();
	
	Number* n13 = n1->clone();
	n13->val = n13->val/3;
	
	Number* n23 = n13->clone();
	n23->val = n23->val*2;
	
	//----- X coordinate -----------------//
	for(i=0;i<4;i++)
		bt->m->setVal(i,0,n1);
	
	for(i=4;i<7;i++)
	{
		bt->m->setVal(i,0,n23);
		bt->m->setVal(i,1,n13);
	}
	
	for(i=7;i<9;i++)
	{
		bt->m->setVal(i,0,n13);
		bt->m->setVal(i,1,n23);
	}
	bt->m->setVal(9,1,n1);
	
	//----- Y coordinate -----------------//
	for(i=10;i<20;i++)
		bt->m->setVal(i,i-8,n1);

	//----- Velocity -----------------//
	for(i=20;i<30;i++)
		bt->m->setVal(i,i-8,n1);
	
	
	//----------- Finished building matrix -------
	
	
	
	
	return bt;
}


BlockType::BlockType()
{
}

BlockType::~BlockType()
{
}
