#include "HyperIndex.h"


int HyperIndex::compareHyperIndices_le(HyperIndex *a, HyperIndex* b)
{
	int il,ic;


	for(il=0;il<a->n_rows;il++)
		for(ic=0;ic<=a->line[il]->dim;ic++)
			if(a->line[il]->mIdx[ic] > b->line[il]->mIdx[ic])
				return 0;


	return 1;


}


HyperIndex::~HyperIndex()
{
}


bool HyperIndex::equals(HyperIndex* op)
{
	int i,j;



	if(((HyperIndex*)op)->n_rows != this->n_rows)
		return false;


	for(i=0;i<this->n_rows;i++)
	{
		if(this->line[i]->dim != op->line[i]->dim)
			return false;

		for(j=0;j<=this->line[i]->dim;j++)
			if(this->line[i]->mIdx[j]!= op->line[i]->mIdx[j] )
				return false;
	}
		return true;
}


std::vector<HyperIndex*> HyperIndex::getAllIndexes(MultiIndex* r,MultiIndex* dim)
{
	std::vector<MultiIndex*> ivec;
	std::vector<HyperIndex*> hveca,hvecb;
	std::vector<MultiIndex*>::iterator iter;

	MultiIndex *midx,*newr,*newdim;
	int order = r->dim+1;
	int i;


	if(order==1) //basis
	{
		ivec = MultiIndex::getMultiIdxSet(r->mIdx[0],dim->mIdx[0]);
		hveca = HyperIndex::fromMultiIdxVector(ivec);
		return hveca;
	}




	//if(order==2) //basis
	{
		newr = r->supressLast();
		//newr->print(stderr);
		newdim = dim->supressLast();
		//newdim->print(stderr);


		hveca = HyperIndex::getAllIndexes(newr,newdim);

		ivec = MultiIndex::getMultiIdxSet(r->mIdx[order-1],dim->mIdx[order-1]);

		for(iter=ivec.begin();iter!=ivec.end();iter++)
		{
			midx = (MultiIndex*)*iter;
			hvecb = HyperIndex::addLine(midx,hveca,hvecb);
		}


		return hvecb;

	}





}


Integer* HyperIndex::combination(HyperIndex* a, HyperIndex* b)
{

	int i;
	if(!(a->dim->equals(b->dim)))
		return new Integer(0);

	Integer* aux = MultiIndex::combination(a->line[0],b->line[0]);
	Integer* aux2;
	Integer* aux3;

	for(i=1;i<a->n_rows;i++)
	{
		aux2 = MultiIndex::combination(a->line[i],b->line[i]);
		aux3 = aux->times(aux2);
		delete(aux2);
		delete(aux);
		aux = aux3;
	}


	return aux;

}


HyperIndex* HyperIndex::clone()
{
	HyperIndex* mtx = new HyperIndex(this->n_rows,this->dim );
	int i;

	for(i=0;i<this->n_rows;i++)
		mtx->line[i] = this->line[i]->clone();

	return mtx;
}


HyperIndex* HyperIndex::sub(HyperIndex* op)
{
	HyperIndex* mtx = new HyperIndex(this->n_rows,this->dim );
	int i;

	for(i=0;i<this->n_rows;i++)
		mtx->line[i] = this->line[i]->sub(op->line[i]);

	return mtx;
}

int HyperIndex::sum()
{
	int i;
	int sum=0;

	for(i=0;i<this->n_rows;i++)
		sum += this->line[i]->sum();

	return sum;
}


HyperIndex* HyperIndex::supressFirst()
{
	HyperIndex* mtx = new HyperIndex(this->n_rows-1,(MultiIndex*)this->dim->supressFirst() );
	int i;

	for(i=1;i<this->n_rows;i++)
		mtx->line[i-1] = this->line[i]->clone();

	return mtx;
}

HyperIndex* HyperIndex::supressFirstElement()
{
	HyperIndex* mtx = new HyperIndex(this->n_rows,this->dim );
	int i;

	mtx->dim->mIdx[0] = mtx->dim->mIdx[0]-1;

	mtx->line[0] = (MultiIndex*)this->line[0]->MultiIndex::supressFirst();

	for(i=1;i<this->n_rows;i++)
		mtx->line[i] = this->line[i]->clone();

	return mtx;
}


HyperIndex::HyperIndex(int rows)
{
	this->n_rows = rows;
	this->line = new MultiIndex*[rows];
}

HyperIndex::HyperIndex(int rows,MultiIndex* dim)
{
	this->n_rows = rows;
	this->line = new MultiIndex*[rows];
	this->dim = dim->clone();
}

HyperIndex::HyperIndex(MultiIndex* dim)
{
	this->n_rows = dim->dim+1;
	this->line = new MultiIndex*[this->n_rows];
	this->dim = dim->clone();
}


void HyperIndex::allocate()
{
	int i;
	for(i=0;i<this->n_rows;i++)
		this->line[i] = new MultiIndex(this->dim->mIdx[i]);
}


HyperIndex* HyperIndex::fromMultiIdx(MultiIndex* i)
{
	HyperIndex* mtx = new HyperIndex(1,new MultiIndex(0,i->dim) );
	mtx->line[0] = i->clone();

	return mtx;
}


HyperIndex* HyperIndex::fromMultiIdx(MultiIndex* i,MultiIndex* dim)
{
	if(i->dim != (dim->dim + dim->sum()))
		return NULL;

	HyperIndex* mtx = new HyperIndex(dim->dim+1,dim);
	mtx->allocate();

	int j,jj,k;

	for(j=0,k=0;j<= dim->dim;j++)
		for(jj=0;jj<=dim->mIdx[j];jj++,k++)
			mtx->line[j]->mIdx[jj] = i->mIdx[k];

	return mtx;
}

MultiIndex* HyperIndex::toMultiIdx()
{
	int size = (dim->dim +1 + dim->sum());

	MultiIndex* i = new MultiIndex(size-1);

	int j,jj,k;

	for(j=0,k=0;j<= this->dim->dim;j++)
		for(jj=0;jj<= this->dim->mIdx[j];jj++,k++)
			 i->mIdx[k] = this->line[j]->mIdx[jj];

	return i;
}

HyperIndex* HyperIndex::getZeroHyperIdx(int order)
{
	HyperIndex* mtx;
	int i;

	MultiIndex* idx = new MultiIndex(order,0);

	mtx = new HyperIndex(order,idx);
	for(i=0;i<order;i++)
	{
		mtx->line[i] = new MultiIndex(0,0);
	}



	return mtx;
}

HyperIndex* HyperIndex::getZeroHyperIdx( int order,int* dim)
{
	HyperIndex* mtx;
	int i,j;

	MultiIndex* idx = new MultiIndex(order);

	for(i=0;i<order;i++)
		idx->mIdx[i]=dim[i];


	mtx = new HyperIndex(order,idx);
	for(i=0;i<order;i++)
	{
		mtx->line[i] = new MultiIndex(dim[i],0);

	}



	return mtx;
}

std::vector<HyperIndex*> HyperIndex::addLine(MultiIndex* i,std::vector<HyperIndex*> v, std::vector<HyperIndex*> acum)
{
	std::vector<HyperIndex*>::iterator iter;
	HyperIndex* mtx;

	for(iter=v.begin();iter!=v.end();iter++)
	{
		mtx = (*iter);
		acum.push_back(mtx->addLine(i));
	}

	return acum;
}

HyperIndex* HyperIndex::addLine(MultiIndex* i)
{

	MultiIndex* newdim = this->dim->insertElement(this->dim->dim+1,i->dim) ;
	HyperIndex* mtx = new HyperIndex(this->n_rows + 1,newdim );

	int j;

	for(j=0;j<this->n_rows;j++)
	{
		mtx->line[j] = this->line[j];
	}
	mtx->line[j] = i;


	delete newdim;


	return mtx;
}

std::vector<HyperIndex*> HyperIndex::fromMultiIdxVector(std::vector<MultiIndex*> v)
{
	std::vector<HyperIndex*> newv;
	std::vector<MultiIndex*>::iterator iter;

	HyperIndex* mtx;

	for(iter=v.begin();iter!=v.end();iter++)
	{
		mtx = HyperIndex::fromMultiIdx(*iter);
		newv.push_back(mtx);
	}


	return newv;
}



void HyperIndex::print(FILE* fp)
{
	int i;
	fprintf(fp,"{");
	for(i=0;i<this->n_rows;i++)
		this->line[i]->print(fp);
	fprintf(fp,"}");
}


Integer* HyperIndex::factorial()
{
	Integer* res;
	Integer* tmp01I;
	Integer* tmp02I;


	res = new Integer(1);

	int i;
	for(i=0;i<=this->dim->dim;i++)
	{
		tmp01I = this->line[i]->factorial();
		tmp02I = res;
		res = tmp02I->times(tmp01I);

		delete tmp01I;
		delete tmp02I;

	}

	return res;
}


void HyperIndex::load_MultiIndex_r()
{
	this->r = new MultiIndex(this->dim->dim);

	int i;
	for(i=0;i<=this->dim->dim;i++)
		r->mIdx[i] = this->line[i]->sum();

}


