#ifndef HYPERINDEX_H_
#define HYPERINDEX_H_

#include "../dataStruct/MultiIndex.h"
#include<vector>
#include<stdio.h>

class HyperIndex
{

public:
	int n_rows;
	MultiIndex* dim;

	MultiIndex** line;
	MultiIndex *r;


public:
	//HyperIndex();
	virtual ~HyperIndex();


	bool equals(HyperIndex* op);
	static std::vector<HyperIndex*>  getAllIndexes(MultiIndex* r,MultiIndex* dim);
	HyperIndex*  clone();
	HyperIndex*  sub(HyperIndex* op);
	int  sum();
	HyperIndex*  supressFirst();
	HyperIndex*  supressFirstElement();

	void load_MultiIndex_r();



	static int compareHyperIndices_le(HyperIndex* a, HyperIndex* b);

	static Integer* combination(HyperIndex* a, HyperIndex* b);



	Integer* factorial();

	 HyperIndex(int rows);
	 HyperIndex(int rows,MultiIndex* dim);
	 HyperIndex(MultiIndex* dim);


	static HyperIndex*  fromMultiIdx(MultiIndex* i);
	static HyperIndex*  fromMultiIdx(MultiIndex* i,MultiIndex* dim);
	MultiIndex*  toMultiIdx();
	static HyperIndex*  getZeroHyperIdx(int order);
	static HyperIndex*  getZeroHyperIdx( int order,int* dim);
	static std::vector<HyperIndex*>  addLine(MultiIndex* i,std::vector<HyperIndex*> v, std::vector<HyperIndex*> acum);
	HyperIndex*  addLine(MultiIndex* i);
	static std::vector<HyperIndex*>  fromMultiIdxVector(std::vector<MultiIndex*> v);
	void  print(FILE* fp);

	void allocate();














};

#endif /*HYPERINDEX_H_*/
