/*
 * DomainMapping.h
 *
 *  Created on: 11/05/2009
 *      Author: lucas
 */

#ifndef DOMAINMAPPING_H_
#define DOMAINMAPPING_H_


#include  "../dataType/IrregularMatrix.h"
#include  "../domain_and_range/DomainPoint.h"
#include  "../dataType/Matrix.h"


class DomainMapping {
public:

	MultiIndex* origDomain;
	MultiIndex* destDomain;


	/*
	 * Matrix "M" of (regular) matrices
	 * "M"'s dimensions are (order-of-origDomain)x(order-of-destDomain)
	 */
	Matrix*** M;
	
	/*
	 * An irregular matrix "IM" of irregular matrices. 
	 * IM's multi-dimension is the same of the destDomain
	 */ 
	IrregularMatrix*** IM;

	DomainMapping();
	static Matrix* buildAffineTransf_Ak_to_Ad(int k,int d,DomainPoint** canonicalImg);
	static DomainMapping* example01();
	static DomainMapping* example02();
	static DomainMapping* example03();
	static DomainMapping* example04();
	void buildIM_matrices();
	
	
	DomainPoint* map_Ak_to_Ad(DomainPoint* u, int k_idx, int d_idx);
	
	DomainPoint* map_A_delta_to_Ad(DomainPoint* u,  int d_idx);
	DomainPoint* map_A_delta_to_Ad_usingIM(DomainPoint* u,  int d_idx);
	
	DomainPoint* map_A_delta_to_A_epsilon(DomainPoint* u);
	DomainPoint* map_A_delta_to_A_epsilon_usingIM(DomainPoint* u);

	
	void allocateM();
	void deallocateM();
	
	void allocateIM();
	
	virtual ~DomainMapping();
};

#endif /* DOMAINMAPPING_H_ */
