#ifndef BERNSTEIN_H_
#define BERNSTEIN_H_

#include "../dataStruct/MultiIndex.h"
#include "../dataStruct/HyperIndex.h"
#include "../dataStruct/MatrixIndex.h"
#include "../domain_and_range/DomainPoint.h"
#include "../domain_and_range/DomainMapping.h"
#include "../dataType/Number.h"


class Bernstein
{

public:
	 std::vector<HyperIndex*> hIdx_v;
	 std::vector<Number*> coef_v;

public:
	Bernstein();
	virtual ~Bernstein();
	static Number* eval(MultiIndex* mdeg, HyperIndex* hIdx, DomainPoint* U);
	static Number* eval(int g, MultiIndex* mIdx, DomainPoint* U);
	static Number* C_00(int d, MultiIndex* kappa, MultiIndex* delta, HyperIndex* omega, DomainMapping* DM,int j);
	static Number* C_01(int d, MultiIndex* kappa, MultiIndex* delta, HyperIndex* omega, DomainMapping* DM);
	static Number* C_02(MultiIndex* delta, MultiIndex* epsilon, MultiIndex* alpha, MultiIndex* nu, HyperIndex* Lambda, HyperIndex* Upsilon, DomainMapping* DM);
	static Number* C_03(MultiIndex* delta, MultiIndex* epsilon, MultiIndex* alpha, HyperIndex* Lambda, HyperIndex* Omega, DomainMapping* DM);

	static std::vector<HyperIndex*> get_Omegas_for_composition_Adelta_to_Aepsilon_fixed_mdegree(int alpha_sum, MultiIndex* delta);
	static std::vector<HyperIndex*> get_Omegas_for_composition_Adelta_to_Ad(int m, MultiIndex* delta, int g);
	static std::vector<HyperIndex*> get_Upsilons_for_composition_Adelta_to_Aepsilon(int alpha_sum, int m, MultiIndex* delta);

	static std::vector<Number*> get_C_03s_for_each_Omega(MultiIndex* delta, MultiIndex* epsilon, MultiIndex* alpha, HyperIndex* Lambda, std::vector<HyperIndex*> Omega_v, DomainMapping* DM);
	static std::vector<Number*> get_C_01s_for_each_Omega(int d, MultiIndex* kappa, MultiIndex* delta, std::vector<HyperIndex*> omega_v, DomainMapping* DM);
	static std::vector<Number*> get_C_02s_for_each_Upsilon(MultiIndex* delta, MultiIndex* epsilon, MultiIndex* alpha, HyperIndex* Lambda, std::vector<HyperIndex*> Upsilon_v, DomainMapping* DM);
	static Number* eval_summation_over_vector_of_indices(std::vector<HyperIndex*> hIdx_v, std::vector<Number*> coef_v,DomainPoint* U);
	 void precompute_composition_Adelta_to_Ad(int g, MultiIndex* kappa, MultiIndex* delta, int d, DomainMapping* DM);
	 void precompute_composition_Adelta_to_Aepsilon(MultiIndex* alpha, MultiIndex* delta, MultiIndex* epsilon, HyperIndex* Lambda,DomainMapping* DM);
	 void precompute_composition_Adelta_to_Aepsilon_fixed_mdegree(MultiIndex* alpha, MultiIndex* delta, MultiIndex* epsilon, HyperIndex* Lambda,DomainMapping* DM);
	 Number* eval_summation_over_precomputed_indices_and_coefs(DomainPoint* U);
};

#endif /*BERNSTEIN_H_*/
