#ifndef IRREGULARMATRIX_H_
#define IRREGULARMATRIX_H_

#include "../dataStruct/MultiIndex.h"
#include "../dataStruct/HyperIndex.h"
#include "../dataType/Number.h"
#include <stdio.h>
#include <vector>

class IrregularMatrix
{
	
public:
	MultiIndex* mDim;
	Number*** data;

	
	
public:
	IrregularMatrix(MultiIndex* mDim);
	Number* pow_elements(IrregularMatrix* exp);
	Number* pow_elements(HyperIndex* exp);
	Number* multiply_elements(IrregularMatrix* op);
	Number* dotProduct(IrregularMatrix* op);
	IrregularMatrix* multiply_by_scalar(Number* a);
	IrregularMatrix* add(IrregularMatrix* op);
	
	bool validIdxs(int i,int j);
	
	Number* get(int i,int j);
	void setVal(int i,int j,Number* n);
	
	void allocate();
	void deallocate();
	
	
	IrregularMatrix* getRows(int nrows,int* ridx);
	IrregularMatrix* getRow(int ridx);
	void setRow(int ridx,IrregularMatrix* r);
	
	
	static IrregularMatrix* fromNumber1DVector(int length,Number** v);
	
	IrregularMatrix* insertElement(int i,int j, Number* n);
	IrregularMatrix* insertRow(int i, IrregularMatrix* row);
	
	Number* rowSum(int row_n);
	
	
	std::vector<IrregularMatrix*> insertElement(int i,int j, Number* n, std::vector<IrregularMatrix*> v, std::vector<IrregularMatrix*> accum);
	std::vector<IrregularMatrix*> insertRow(int i,IrregularMatrix* row, std::vector<IrregularMatrix*> v, std::vector<IrregularMatrix*> accum);
	
	
	virtual ~IrregularMatrix();
	
	/*
	 * Debugging methods
	 */
	void print(FILE* fp);
	void printPlot(FILE* fp);
};

#endif /*IRREGULARMATRIX_H_*/
