#include "dataStruct/MultiIndex.h"
#include "dataStruct/HyperIndex.h"
#include "dataStruct/MatrixIndex.h"

#include "mathFunctions/Bernstein.h"

#include "domain_and_range/DomainPoint.h"
#include "domain_and_range/DomainMapping.h"
#include "dataType/IrregularMatrix.h"
#include "dataType/Number.h"
#include <stdio.h>
#include <stdlib.h>
#include <vector>

int main()
{
	
	FILE* fp1 = fopen("/home/lbfreitas/t01","w");
	FILE* fp2 = fopen("/home/lbfreitas/t02","w");
		
	fprintf(stderr,"start:\n");
	MultiIndex* delta = new MultiIndex(1,1);
	MultiIndex* epsilon = new MultiIndex(1,1);
	
	std::vector<DomainPoint*> v_delta,v_epsilon;
	std::vector<DomainPoint*>::iterator iter;
	
	//Adelta
	v_delta = DomainPoint::domainPoints(delta,50);
	v_epsilon = DomainPoint::domainPoints(epsilon,50);
	DomainPoint* U_delta;
	DomainPoint* U_epsilon;

	
	DomainMapping *DM = DomainMapping::example04();
	DM->allocateIM();
	DM->buildIM_matrices();
	
	
	
	// B^alpha_Lambda(U_epsilon = Gamma(U_delta))
	MultiIndex* alpha = new MultiIndex(1,3);
	MultiIndex* kappa = new MultiIndex(1);
	kappa->mIdx[0]=1;
	kappa->mIdx[1]=2;
	
	HyperIndex* Lambda = new HyperIndex(epsilon);
	Lambda->line[0] = kappa->clone();
	kappa->mIdx[0]=2;
	kappa->mIdx[1]=1;
	Lambda->line[1] = kappa->clone();
	
	
	
	
	Number* BU_usingDM;
	Number* BV;
	
	Bernstein* Bern = new Bernstein();
	
	Bern->precompute_composition_Adelta_to_Aepsilon(alpha, delta, epsilon,Lambda,DM);
	//Bern->precompute_composition_Adelta_to_Ad(3,kappa,mdim,2,DM);
	
	for(iter=v_delta.begin();iter!=v_delta.end();iter++)
	{
		U_delta = (DomainPoint*)(*iter);
		
		U_epsilon = DM->map_A_delta_to_A_epsilon_usingIM(U_delta);
		
		
		BV = Bernstein::eval(alpha, Lambda,U_epsilon);
		
		BU_usingDM = Bern->eval_summation_over_precomputed_indices_and_coefs(U_delta);
		
		
		U_epsilon->printPlot(BU_usingDM,fp1);
		//U_epsilon->printPlot(BV,fp2);
		
		
		
	}	
	for(iter=v_epsilon.begin();iter!=v_epsilon.end();iter++)
	{
		U_epsilon = (DomainPoint*)(*iter);
		
		
		BV = Bernstein::eval(alpha, Lambda,U_epsilon);
		
		U_epsilon->printPlot(BV,fp2);
		
		
	}
		
	
	
	fclose(fp1);
	fclose(fp2);
		
	fprintf(stderr,"\ndone!\n");
}
