/* Last edited on 2008-07-14 20:40:39 by stolfi */

#include <delaunay.h>
#include <delaunay_plot.h>

#include <quad.h>
#include <bool.h>
#include <affirm.h>

#include <ioprotos.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>

#define VERBOSE 0

void makesites(int ni, int nj, bool_t polar, int *nsitesp, delaunay_site_t **stp);

int main(int argc, char **argv);

int main(int argc, char **argv)
  { int ni = atoi(argv[1]);
    int nj = atoi(argv[2]);
    bool_t polar = (strcmp(argv[3], "polar") == 0);
    bool_t eps = (strcmp(argv[4], "eps") == 0);
    quad_arc_t e;
    delaunay_site_t *st = NULL;
    int nsites;
    makesites(ni, nj, polar, &nsites, &st);
    e = delaunay_build (st, nsites);
    printf("Delaunay returned %x:%d \n", (e & 0xfffffffcu), (e&3));
    plot_delaunay(e, st, nsites, "delgrid", eps);
    return(0);
  }

void makesites(int ni, int nj, bool_t polar, int *nsitesp, delaunay_site_t **stp)
  { 
    int nsites = ni*nj;
    delaunay_site_t *st = notnull(malloc(nsites*sizeof(delaunay_site_t)), "no mem");
    
    double fnx = (double)nj; /* Number of steps in {x}. */
    double fny = (double)ni; /* Number of steps in {y}. */
    
    int i, j;
    int k = 0;
    if (polar) 
      { /* Polar grid with {ni} layers of {nj} sites, slightly twisted: */
        /* Angular increment: */
        double dt = 2*M_PI/(nj <= 1 ? 1.0 : nj-1);
        /* Radius reduction factor: */
        double rredf = 1.0 - (nj <= 12 ? 0.50 : (2*M_PI)/nj); 
        /* Relative twist between layers (fraction of a {j}-step): */
        double dtwist = 0.50/(ni <= 1 ? 1 : ni-1);
        double r = 1.0; /* Radius of current layer. */
        for (i=0; i < ni; i++) 
          { /* Add layer {i} at radius {r} counting from outside in: */
            for (j=0; j < nj; j++) 
              { double t = (j + i*dtwist)*dt;
                st[k].c[0] = r*cos(t);
                st[k].c[1] = r*sin(t);
                k++;
              }
            r = rredf * r;
          }
      }
    else 
      { /* Rectangular grid, slightly sheared and squeezed: */
         /* Compute grid steps: */
        double dy = 2.0/(ni <= 1 ? 1.0 : fny-1);
        double dx = 2.0/(nj <= 1 ? 1.0 : fnx-1);
        /* Relative X displacement between layers (fraction of a {j}-step): */
        double shear = 0.01;
        double shrink = 0.001;
        for (i=0; i < ni; i++) 
          { /* Add horizontal layer {i}: */
            double y = (i - fny/2)*dy;
            for (j=0; j < nj; j++) 
              { double x = ((j - fnx/2) + shear*(i - fny/2))*dx;
                double scale = 1.0 + shrink*(x*x + y*y); 
                st[k].c[0] = x/scale;
                st[k].c[1] = y/scale;
                k++;
              }
          }
      }
    if (VERBOSE) 
      { for (k = 0; k < nsites; k++)
          { fprintf(stderr, "%3d (%12.8f, %12.8f)\n", k, st[k].c[0], st[k].c[1]); }
      }
    (*nsitesp) = nsites; (*stp) = st;
  }
