/* Last edited on 2007-12-24 00:40:24 by stolfi */

#include <delaunay.h>
#include <delaunay_plot.h>

#include <quad.h>
#include <affirm.h>
#include <pswr.h>
#include <jsrandom.h>

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>

#define NORMAL 1
#define NTOSS 9
#define VERBOSE 0
#define RBIG 10.0

delaunay_site_t *makesites(int nsites, bool_t normal);

int main(int argc, char **argv);

int main(int argc, char **argv)
  { int nsites = atoi(argv[1]);
    bool_t normal = (strcmp(argv[2], "normal") == 0);
    bool_t eps = (strcmp(argv[3], "eps") == 0);
    quad_arc_t e;
    delaunay_site_t *st = makesites(nsites, normal);
    e = delaunay_build (st, nsites);
    printf("Delaunay returned %x:%d \n", (e & 0xfffffffcu), (e&3));
    plot_delaunay(e, st, nsites, "delrandom", eps);
    return(0);
  }

delaunay_site_t *makesites(int nsites, bool_t normal)
  { int i, j;
    double s, t;
    delaunay_site_t *st = notnull(malloc(nsites*sizeof(delaunay_site_t)), "no mem");
    
    srandom(4615);

    for (i=0; i < nsites; i++) 
      { if (normal) 
          { /* central limit approx to normal distribuition: */
            s = t = 0.0;
            for (j=0; j<NTOSS; j++)
              { s += 2 * (drandom() - 0.5);
                t += 2 * (drandom() - 0.5);
              }
            st[i].c[0] = s/sqrt(NTOSS);
            st[i].c[1] = t/sqrt(NTOSS);
          }
        else 
          { /* uniform distribution: */
            st[i].c[0] = 2 * (drandom() - 0.5);
            st[i].c[1] = 2 * (drandom() - 0.5);
          }
        if (VERBOSE) 
          { fprintf(stderr, "%3d (%12.8f, %12.8f)\n", i, st[i].c[0], st[i].c[1]); }
      }
    return st;
  }
