/* See r6x6.h. */
/* Last edited on 2009-01-06 03:59:44 by stolfi */

#include <r6x6.h>
#include <r6.h>
#include <math.h>
#include <stdio.h>
#include <rmxn.h>

#define N 6

void r6x6_zero(r6x6_t *M)
  { int i, j;
    for (i = 0; i < N; i++)
      for (j = 0; j < N; j++)
        { M->c[i][j] = 0.0; }
  }

void r6x6_ident(r6x6_t *M)
  { int i, j;
    for (i = 0; i < N; i++)
      for (j = 0; j < N; j++)
        { M->c[i][j] = (i == j ? 1.0 : 0.0); }
  }

void r6x6_transp (r6x6_t *A, r6x6_t *M)
  { 
    int i, j;
    for (i = 0; i < N; i++)
      { M->c[i][i] = A->c[i][i]; 
        for (j = 0; j < i; j++)
          { double a = A->c[i][j];
            double b = A->c[j][i];
            M->c[i][j] = b;
            M->c[j][i] = a;
          }
      }
  }

void r6x6_map_row (r6_t *x, r6x6_t *A, r6_t *r)
  { r6_t rr;
    int j, k;
    for (j = 0; j < N; j++)
      { double s = 0.0;
        for (k = 0; k < N; k++) s += x->c[k] * A->c[k][j];
        rr.c[j] = s;
      }
    (*r) = rr;
  }

void r6x6_map_col (r6x6_t *A, r6_t *x, r6_t *r)
  { r6_t rr;
    int i, k;
    for (i = 0; i < N; i++)
      { double s = 0.0;
        for (k = 0; k < N; k++) s += A->c[i][k] * x->c[k];
        rr.c[i] = s;
      }
    (*r) = rr;
  }

void r6x6_scale (double s, r6x6_t *A, r6x6_t *M)  
  { int i, j;
    for (i = 0; i < N; i++)
      for (j = 0; j < N; j++)
        { M->c[i][j] = s * A->c[i][j]; }
  }

void r6x6_mul (r6x6_t *A, r6x6_t *B, r6x6_t *M)
  { r6x6_t RR;
    int i, j, k;
    for (i = 0; i < N; i++)
      for (j = 0; j < N; j++)
        { double s = 0.0;
          for (k = 0; k < N; k++)  s += A->c[i][k]*B->c[k][j];
          RR.c[i][j] = s;
        }
    (*M) = RR;
  }

void r6x6_mul_tr (r6x6_t *A, r6x6_t *B, r6x6_t *M)
  {
    r6x6_t RR;
    int i, j, k;
    for (i = 0; i < N; i++)
      for (j = 0; j < N; j++)
        { double s = 0.0;
          for (k = 0; k < N; k++)  s += A->c[i][k]*B->c[j][k];
          RR.c[i][j] = s;
        }
    (*M) = RR;
  }

double r6x6_det (r6x6_t *A)
  { return rmxn_det(N, &(A->c[0][0])); }

void r6x6_inv (r6x6_t *A, r6x6_t *M)
  { (void)rmxn_inv(N, &(A->c[0][0]), &(M->c[0][0])); }

bool_t r6x6_is_unif_scaling(r6x6_t *M, double s)
  {
    int i, j;
    for (i = 0; i < N; i++)
      for (j = 0; j < N; j++)
        { if (M->c[i][j] != (i == j ? s : 0.0)) { return FALSE; } }
    return TRUE;
  }

void r6x6_print (FILE *f, r6x6_t *A)
  { r6x6_gen_print(f, A, NULL, NULL, NULL, NULL, NULL, NULL, NULL); }

void r6x6_gen_print 
  ( FILE *f, r6x6_t *A,
    char *fmt, 
    char *olp, char *osep, char *orp,
    char *ilp, char *isep, char *irp
  )
  { rmxn_gen_print(f, N, N, &(A->c[0][0]), fmt, olp, osep, orp, ilp, isep, irp); }

