#ifndef float_image_test_H
#define float_image_test_H

/* Tools for testing programs that deal with {float_image_t}. */
/* Last edited on 2009-06-02 23:44:42 by stolfi */ 

#include <float_image.h>
#include <r2.h>

typedef void float_image_test_generator_t (r2_t *p, int NC, int NX, int NY, float fs[]);
  /* Type of a procedure that defines a procedural image with {NC} channels, 
    {NX} columns, and {NY} rows.
    
    More precisely, a procedure of this type must return in
    {fs[0..chns-1]} the value of the pixel whose center is the point
    {p}. The procedure should remove frequencies above the Nyquist
    limit, assuming that the pixel spacing is 1 along each axis. Note
    that pixel centers have half-integer coordinates. */

void float_image_test_paint(float_image_t *img, float_image_test_generator_t proc);
  /* Paints into {img} the procedural image defined by {proc}. */

/* IMAGE GENERATORS: */

void float_image_test_gen_ripples(r2_t *p, int NC, int NX, int NY, float fs[]);
void float_image_test_gen_stripes(r2_t *p, int NC, int NX, int NY, float fs[]);
void float_image_test_gen_checker(r2_t *p, int NC, int NX, int NY, float fs[]);

#endif
