/* jspgm_medcutx.h - choose a representative set of N grays, from gray histogram */
/* Last edited on 2006-11-10 19:25:29 by stolfi */ 

#ifndef jspgm_medcutx_H
#define jspgm_medcutx_H

#include <jspnm.h>

typedef pnm_sample_t *pgm_pixel_vector;

extern pgm_pixel_vector
pgm_median_cut_x(
    long *gh,              /* Pixel count indexed by gray level */
    pnm_sample_t maxval,   /* maxval of pixel values, also size of "gh" */
    int *newgraysp         /* In: desired number of grays, out: number chosen */
  );
  /*
    Chooses a good set of gray values for image quantization,
    given the image's histogram.
    
    Based on Paul Heckbert's median cut algorithm, as described in
    "Color Image Quantization for Frame Buffer Display", SIGGRAPH '82
    Proceedings, page 297.
  */

#endif
