/* jsppm_medcutx.h - choose a representative set of N colors, from color histogram */
/* Last edited on 2006-11-13 22:54:19 by stolfi */ 

#ifndef jsppm_medcutx_H
#define jsppm_medcutx_H

#include <jspnm.h>
#include <jsppm_xhist.h>

#define MAXCOLORS 32767

ppm_xhist_vector ppm_median_cut_x
  ( ppm_xhist_vector ch,  /* Color histogram of image. */
    int colors,           /* Size of {ch}. */
    pnm_sample_t maxval,  /* Max valid sample value. */
    int *newcolorsp       /* In: desired number of colors, out: number chosen */
  );
  /* Chooses a good set of pixel values for color image quantization,
    given the image's histogram.
    
    Based on Paul Heckbert's median cut algorithm, as described in
    "Color Image Quantization for Frame Buffer Display", SIGGRAPH '82
    Proceedings, page 297. */

#endif
