/* jsppm_xhist.h - color histogram tools */
/* Last edited on 2009-01-07 01:38:23 by stolfi */ 

/* Sub-clone of Jef Poskanzer's ppmcmap.h */

#ifndef jsppm_xhist_H
#define jsppm_xhist_H

#include <jspnm.h>

typedef struct ppm_pixel_t { pnm_sample_t c[3]; } ppm_pixel_t;
  /* An RGB pixel. */

typedef struct ppm_xhist_item { ppm_pixel_t color; int value; } ppm_xhist_item;
  /* An entry of an RGB histogram. */

typedef struct ppm_xhist_item* ppm_xhist_vector;

ppm_xhist_vector ppm_xhist_build 
  ( pnm_sample_t** samples, 
    int chns,
    int cols, 
    int rows,
    int maxcolors, 
    int* colorsP
  );
  /* Returns a {ppm_xhist_vector} with space allocated for {maxcolors} entries,
    where the first {*colorsP} entries are taken from the given samples.
    Assumes that each row consists of {cols} pixels, each with {chns} samples, 
    all consecutive. */

int ppm_equal(ppm_pixel_t *a, ppm_pixel_t *b);
  /* TRUE if the two pixels {a,b} are identical. */

void ppm_xhist_add
  ( ppm_xhist_vector chv, 
    int* colorsP, 
    int maxcolors, 
    ppm_pixel_t* colorP,
    int value, 
    int position
  );

void ppm_xhist_free (ppm_xhist_vector chv);

#endif
