/* jsppm_xtable.h - hash table of RGB colors */
/* Last edited on 2009-01-07 01:40:57 by stolfi */ 

#ifndef jsppm_xtable_H
#define jsppm_xtable_H

#include <jspnm.h>
#include <jsppm_xhist.h>

typedef struct ppm_xbucket_item *ppm_xbucket;
typedef struct ppm_xbucket_item { struct ppm_xhist_item ch; ppm_xbucket next; } ppm_xbucket_item;

typedef ppm_xbucket *ppm_xtable;

ppm_xtable ppm_xtable_build
  ( pnm_sample_t **samples,
    int chns, 
    int cols, 
    int rows, 
    int maxcolors, 
    int *colorsP );

int ppm_xtable_lookup (ppm_xtable cht, ppm_pixel_t *colorP);

ppm_xhist_vector ppm_xtable_to_xhist (ppm_xtable cht, int maxcolors);
ppm_xtable ppm_xhist_to_xtable (ppm_xhist_vector chv, int colors);

int ppm_xtable_add (ppm_xtable cht, ppm_pixel_t *colorP, int value);
  /* Returns -1 on failure. */

ppm_xtable ppm_xtable_alloc (void);

void ppm_xtable_free (ppm_xtable cht);

#endif
