/* See filefmt.h */
/* Last edited on 2007-02-03 07:05:26 by stolfi */

#include <filefmt.h>
#include <fget.h>
#include <jsstring.h>
#include <affirm.h>
#include <vec.h>

#include <stdio.h>

void filefmt_write_header(FILE *wr, char *type, char *version)
  { fprintf(wr, "begin %s (format of %s)\n",  type,  version);
  }

void filefmt_write_footer(FILE *wr, char *type)
  { fprintf(wr, "end %s\n",  type);
  }

char *filefmt_make_header(char *type, char *version) 
  { char *h1 = txtcat("begin ", type);
    char *h2 = txtcat(" (format of ", version);
    char *h3 = txtcat(h1, h2);
    char *h = txtcat(h2, ")\n");
    free(h1); free(h2); free(h3);
    return h;
  }

char *filefmt_make_footer(char *type)
  { char *h1 = txtcat("end ", type);
    char *h = txtcat(h1, "\n");
    free(h1);
    return h;
  }

void filefmt_read_header(FILE *rd, char *type, char *version)
  { fget_skip_formatting_chars(rd);
    fget_match(rd, "begin");
    fget_skip_spaces(rd);
    fget_match(rd, type);
    fget_skip_spaces(rd);
    fget_match(rd, "(format of");
    fget_skip_spaces(rd);
    fget_match(rd, version);
    fget_skip_spaces(rd);
    fget_match(rd, ")");
    fget_skip_spaces(rd);
    fget_match(rd, "\n");
  }

void filefmt_read_footer(FILE *rd, char *type)
  { 
    fget_skip_formatting_chars(rd);
    fget_match(rd, "end ");
    fget_skip_spaces(rd);
    fget_match(rd, type);
    fget_skip_spaces(rd);
    fget_match(rd, "\n");
  }

void filefmt_write_comment(FILE *wr, char *cmt, char prefix)
  { if (cmt == NULL) { return; }
    while(*cmt != '\000')
      { /* Write a new line, advance {cmt} to start of next one or to '\000' */
        char c = (*cmt);
        fputc(prefix, wr);
        fputc(' ', wr);
        fputc(c, wr);
        while (c != '\n')
          { cmt++; c = (*cmt); 
            if (c == '\000') { c = '\n'; }
            fputc(c, wr);
          }
        if (*cmt == '\n') { cmt++; }
      }
  }

char *filefmt_read_comment(FILE *rd, char prefix)
  { char_vec_t cmt = char_vec_new(200);
    int ncmt = 0; /* Number of characters read */
    while (TRUE)
      { int c;
        /* Try to get the prefix char: */
        c = fgetc(rd); 
        if (c == EOF) { break; }
        if (c != prefix) { ungetc(c, rd); break; }
        /* Skip optional blank after prefix char: */
        c = fgetc(rd); 
        demand(c != EOF, "missing final newline in comment");
        if (c != ' ') { ungetc(c, rd); }
        /* Read comment text until end-of-line: */
        do
          { c = fgetc(rd); 
            demand(c != EOF, "missing final newline in comment");
            char_vec_expand(&cmt, ncmt);
            cmt.e[ncmt] = c;
            ncmt ++;
          }
        while (c != '\n');
      }
    char_vec_expand(&cmt, ncmt);
    cmt.e[ncmt] = '\000';
    ncmt ++;
    char_vec_trim(&cmt, ncmt);
    return cmt.e;
  }
