#define PROG_NAME "test_oct"
#define PROG_DESC "creates some 2D maps using the quad-edge structure"
#define PROG_VERS "1.0"

/* Last edited on 2009-03-07 20:41:24 by stolfi */ 

#define PROG_COPYRIGHT \
  "Copyright  2007  State University of Campinas (UNICAMP)"
  
#define PROG_AUTH \
  "Created by J. Stolfi on 2009-03-06"
  
#define PROG_HIST
  
#define PROG_HELP \
  "  " PROG_NAME ""

#define _GNU_SOURCE
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>

#include <bool.h>
#include <frgb.h>
#include <argparser.h>
#include <jsfile.h>

#include <oct.h>

int main(int argc, char **argv);
void putwr (oct_arc_t a);
oct_arc_t make_map(void);
void test_basic_ops(oct_arc_t m);
void write_map(char *prefix, oct_arc_t a);

/* IMPLEMENTATIONS: */

int main(int argc, char **argv)
  { oct_arc_t m = make_map();
    test_basic_ops(m);
    write_map("out/test", m);
    return 0;
  }
  
void test_basic_ops(oct_arc_t m)
  {
    /* Check edge/tumblecode decomposition: */
    oct_edge_t E = oct_edge(m);
    assert(E != NULL);
    int it;
    for (it = 0; it < 8; it++)
      { oct_bits_t t = it;
        oct_arc_t e = oct_orient(E, t);
        assert(t == oct_tumble_code(e));
        assert(E == oct_edge(e));
      
        /* Check effect of tumbling ops on tubmble bits: */
        assert(oct_lon_bit(oct_sym(e))    != oct_lon_bit(e));
        assert(oct_lon_bit(oct_vflip(e))  != oct_lon_bit(e));
        assert(oct_lon_bit(oct_fflip(e))  == oct_lon_bit(e));
        
        assert(oct_trn_bit(oct_sym(e))    != oct_trn_bit(e));
        assert(oct_trn_bit(oct_vflip(e))  == oct_trn_bit(e));
        assert(oct_trn_bit(oct_fflip(e))  != oct_trn_bit(e));
        
        assert(oct_dop_bit(oct_sym(e))    == oct_dop_bit(e));
        assert(oct_dop_bit(oct_vflip(e))  == oct_dop_bit(e));
        assert(oct_dop_bit(oct_fflip(e))  == oct_dop_bit(e));
        assert(oct_dop_bit(oct_rot(e))    != oct_dop_bit(e));
        assert(oct_dop_bit(oct_tor(e))    != oct_dop_bit(e));
        assert(oct_dop_bit(oct_dual(e))   != oct_dop_bit(e));
        assert(oct_dop_bit(oct_duar(e))   != oct_dop_bit(e));
        
        assert(oct_cir_bit(oct_sym(e))    == oct_cir_bit(e));
        assert(oct_cir_bit(oct_vflip(e))  != oct_cir_bit(e));
        assert(oct_cir_bit(oct_fflip(e))  != oct_cir_bit(e));
        assert(oct_cir_bit(oct_rot(e))    == oct_cir_bit(e));
        assert(oct_cir_bit(oct_tor(e))    == oct_cir_bit(e));
        assert(oct_cir_bit(oct_dual(e))   != oct_cir_bit(e));
        assert(oct_cir_bit(oct_duar(e))   != oct_cir_bit(e));
        
        /* Check tumbling identities: */
        assert(oct_fflip(e) != e);
        assert(oct_vflip(e) != e);
        assert(oct_fflip(e) != oct_vflip(e));
        assert(oct_sym(e) != e);
        assert(oct_rot(e) != e);
        assert(oct_tor(e) != e);
        assert(oct_rot(e) != oct_tor(e));
        
        assert(oct_fflip(oct_rot(e)) != e);
        assert(oct_vflip(oct_rot(e)) != e);
        assert(oct_sym(oct_rot(e)) != e);
        
        assert(oct_fflip(oct_fflip(e)) == e);
        assert(oct_vflip(oct_vflip(e)) == e);
        assert(oct_sym(oct_sym(e)) == e);
        assert(oct_rot(oct_rot(e)) == oct_sym(e));
        assert(oct_vflip(oct_fflip(e)) == oct_sym(e));
        assert(oct_rot(oct_rot(e)) == oct_sym(e));
        
        /* Check some walking identities: */
        assert(oct_onext(oct_oprev(e)) == e);
        assert(oct_lnext(oct_lprev(e)) == e);
        assert(oct_dnext(oct_dprev(e)) == e);
        assert(oct_rnext(oct_rprev(e)) == e);
        
        assert(oct_rnext(oct_onext(e)) == oct_sym(e));
        assert(oct_lnext(oct_dnext(e)) == oct_sym(e));
        assert(oct_onext(oct_lnext(e)) == oct_sym(e));
        assert(oct_dnext(oct_rnext(e)) == oct_sym(e));

        assert(oct_onext(oct_fflip(e)) == oct_fflip(oct_oprev(e)));
        assert(oct_dnext(oct_fflip(e)) == oct_fflip(oct_dprev(e)));
        assert(oct_lnext(oct_vflip(e)) == oct_vflip(oct_lprev(e)));
        assert(oct_rnext(oct_vflip(e)) == oct_vflip(oct_rprev(e)));

        assert(oct_rot(oct_onext(e)) == oct_lnext(oct_rot(e)));
        assert(oct_rot(oct_dprev(e)) == oct_rprev(oct_rot(e)));
        /* ... many more ... */
      }
  }
    
oct_arc_t make_map(void)
  { /* Build a Klein bottle: */
    oct_arc_t a, b;
    a = oct_make_edge(0); 
    b = oct_make_edge(0);
    oct_splice(a, b);
    oct_splice(oct_sym(a), a);
    oct_splice(oct_fflip(oct_sym(b)), a);
    return a;
  } 
  
void write_map(char *prefix, oct_arc_t a)
  { char *filename = NULL;
    asprintf(&filename, "%s.oct", prefix);
    FILE *wr = open_write(filename, TRUE);
    oct_arcs_t root = oct_arcs_new(1); /* Root list. */
    root.e[0] = a;
    oct_arcs_t et = oct_arcs_new(0); /* Edge table. */
    oct_write_map(wr, &root, &et);
    fclose(wr);
    free(filename);
  }

