double EstLogPrSG_01(const double so[], double Smag, const double go[], double Gmag, int n, double sigma, double omega)
{
  double albedo_estimado = 0.0;
  double dist_alpha = 2.0;

  /* Supondo que não há highlights: */
  if (ao[0].alpha <= 1 + 3*sigma) {
 
    /* Calcula média dos logaritmos dos alphas: */
    double mean = 0;
    int i;
    for(i = 0; i < n;i++){
      mean = mean + log(ao[i].alpha);
    }
    mean = mean/(double)n;
    albedo_estimado = exp(mean);

    /* Distância é o desvio padrão dos logaritmos dos alphas: */
    double var = 0;
    for(i = 0; i < n;i++){
      double di = log(ao[i].alpha) - mean;
      var = var + di*di;
    }
    var = var/(double)(n);
    dist_alpha = sqrt(var)/sigma;
  }
  if (dist_alpha > 2.0) { dist_alpha = 2.0; }
  (*logPrSG) = dist_alpha;
  (*albedo) = albedo_estimado;
}

double ScoreAlphaGroup(const alpha_obs_t ao[], int i, int j, double sigma);
 /* Calcula um escore para um grupo de alphas {alpha[i..j]} consecutivos
   na ordem crescente. O escore é 0 se o conjunto contém apenas 2 alphas,
   senão cresce com o número e similaridade dos alphas nesse conjunto . */

double ScoreAlphaGroup(const alpha_obs_t ao[], int i, int j, double sigma)
{
  assert(i <= j);
  if (j - i <= 2) return 0;
  double alpha_med = sqrt(ao[i].alpha*ao[j].alpha);
  double score = 0;
  int k;
  for (k = j; k <= i; k++) {
    double z = (log(ao[k].alpha) - log(alpha_med))/sigma;
    score = score + exp(-z*z/2);
  }
  return score;
}

double EstLogPrSG_02(const double so[], double Smag, const double go[], double Gmag, int n, double sigma, double omega)
{
  double albedo_estimado = 0.0;
  double dist_alpha = 2.0;

  /* localiza o maior grupo de alphas semelhantes: */
  int i,j,k;
  double alpha_eps = 0.5/256.0; //erro esperado no alpha 
  double scoreMax = 0;
  	
  for(i = 0; i < n;i++){	
    if(ao[i].alpha < alpha_eps) break;
    assert((i == 0) || (ao[i].alpha <= ao[i-1].alpha));
    for(j = i; j >= 0; j--) {
      if ( ao[j].alpha > (ao[i].alpha + 6*sigma*ao[i].alpha)) break;
    }
    double alpha_med = sqrt(ao[i].alpha*ao[j].alpha);
    double alpha_sig = sigma*alpha_med;
    if(debug_dist){
  	//fprintf(stderr, "%d.. %d ",j,i);
    }
    double score = 0;
    for(k =j; k <= i;k++){
  	double z = (ao[k].alpha - alpha_med)/(2*alpha_sig);
  	score = score +  exp(-z*z);
  	if(debug_dist){
  	  //	  fprintf(stderr, "ALPHA_%d: %lf Z:%lf ",k,ao[k].alpha,z);
  	}
    }
    //  if(debug_dist) fprintf(stderr, "ALPHA_MED %lf SCORE %lf\n",alpha_med,score);
    if (score > scoreMax) {
      scoreMax = score;
      albedo_estimado = alpha_med; 
    }
  }
  dist_alpha = 2.0/(1 + scoreMax);
  if (dist_alpha > 2.0) { dist_alpha = 2.0; }
  (*logPrSG) = dist_alpha;
  (*albedo) = albedo_estimado;
}

double EstLogPrSG_03(const double so[], double Smag, const double go[], double Gmag, int n, double sigma, double omega)
{
  double albedo_estimado = 0.0;
  double dist_alpha = 2.0;

  /* Supondo que não há highlights: */
  if (ao[0].alpha <= 1 + 3*sigma) { 

    /* Pega o maior alpha {alpha_max}: */
    double alpha_max = ao[0].alpha; 
    double alpha_eps = 0.5/256.0; // erro relativo esperado no alpha 
    double sigma_alpha = sigma*hypot(alpha_max,alpha_eps); // ruido esperado no alpha
    double alpha_min = (alpha_max - 3*sigma_alpha); // menor alpha interessante
    double score = 0;
    int i;
    for(i = 0; i < n;i++){
      assert(ao[i].alpha <= alpha_max);
      if(ao[i].alpha >= alpha_min){
        double z = (ao[i].alpha - alpha_max)/(2*sigma_alpha);
        score = score +  exp(-z*z);
      }
      else{
        break;
      }
    }
    assert(score >= 1);
    dist_alpha = sqrt(fmax(0, -log(score/(double)n)));
    albedo_estimado = alpha_max;
  }
  if (dist_alpha > 2.0) { dist_alpha = 2.0; }
  (*logPrSG) = dist_alpha;
  (*albedo) = albedo_estimado;
}

double EstLogPrSG_04(const double so[], double Smag, const double go[], double Gmag, int n, double sigma, double omega)
{
  double albedo_estimado = 0.0;
  double dist_alpha = 2.0;

  /* localiza o maior grupo de alphas semelhantes: */
  int i,j;
  double alpha_eps = 0.5/256.0; //erro esperado no alpha 
  double scoreMax = 0;
	
  for(i = 0; i < n;i++){	
    if (ao[i].alpha < alpha_eps) break;
    assert((i ==0) || (ao[i].alpha <= ao[i-1].alpha));
    for(j = i; j >= 0; j--) {
      if (ao[j].alpha > (ao[i].alpha + 6*sigma*ao[i].alpha)){ break; }
    }
    double alpha_med = sqrt(ao[i].alpha*ao[j].alpha);
    double score = ScoreAlphaGroup(ao, j, i, sigma);
    if (score > scoreMax) {
      scoreMax = score;
      albedo_estimado = alpha_med; 
    }
  }
  dist_alpha = 2*exp(-scoreMax*scoreMax/1.5);
  if (dist_alpha > 2.0) { dist_alpha = 2.0; }
  (*logPrSG) = dist_alpha;
  (*albedo) = albedo_estimado;
}

void DistAlpha05_old(const alpha_obs_t ao[], int n, double sigma, double *dist, double *albedo);
void DistAlpha05_old(const alpha_obs_t ao[], int n, double sigma, double *dist, double *albedo)
{
  double albedo_estimado = 0.0;
  double dist_alpha = 2.0;

  double scoreMax = 0;
  int i,j;
  for(i = 0; i < n; i++) {	
    /* Supõe que o albedo é {alpha_i}: */
    double albi = ao[i].alpha;
    /* Calcula o escore para este albedo: */
    double score = 0.0;
    for(j = 0; j < n; j++) {
      //double sigmaj = hypot(1, ao[j].alpha)*sigma;
      double sigmaj = sigma;
      double dOij = ao[j].S_p - albi*ao[j].G_q;
      double zj = dOij/sigmaj;
      double zj2 = zj*zj;
      double prob = (zj2 > 16 ? 0.0 : exp(-zj*zj/2));
      // if(debug_dist){ fprintf(stderr, "  j = %02d  dO = %9.6f  sigj = %9.6f  zj = %9.6f  prob = %8.4f\n", j, dOij, sigmaj, zj, prob); }
      score += prob * ao[j].G_q;
    }
    if(debug_dist){ fprintf(stderr, "i = %02d score = %8.4f\n", i, score); }
    if (score > scoreMax) {
      scoreMax = score;
      albedo_estimado = albi; 
    }
  }
  dist_alpha = 2*exp(-scoreMax*scoreMax/1.5);
  if (dist_alpha > 2.0) { dist_alpha = 2.0; }
  (*logPrSG) = dist_alpha;
  (*albedo) = albedo_estimado;
}

