/* ---------------------------------------------------------------------- */
/* from normals.h,c */

double EstLogPrSG_01(const double so[], double Smag, const double go[], double Gmag, int n, double sigma, double omg0, double omg1);
/* Supõe que não há highlights. */

double EstLogPrSG_02(const double so[], double Smag, const double go[], double Gmag, int n, double sigma, double omg0, double omg1);
/* Exige os alphas ordenados.  ACEITA HIGHLIGHTS (mas nâo garante resposta correta...) */

double EstLogPrSG_03(const double so[], double Smag, const double go[], double Gmag, int n, double sigma, double omg0, double omg1);
/* Exige os alphas ordenados.  Supõe que não há highlights na cena.  */

double EstLogPrSG_04(const double so[], double Smag, const double go[], double Gmag, int n, double sigma, double omg0, double omg1);
/* Exige os alphas ordenados.  ACEITA HIGHLIGHTS.  */

double EstLogPrSG_05(const double so[], double Smag, const double go[], double Gmag, int n, double sigma, double omg0, double omg1);
/* Exige os alphas ordenados.  ACEITA HIGHLIGHTS. Demorada. */

double EstLogPrSG_06(const double so[], double Smag, const double go[], double Gmag, int n, double sigma, double omg0, double omg1);
/* Não exige alphas ordenados.  ACEITA HIGHLIGHTS. Usa Bayes. Demorada. */


double estima_log_prob_S_G
  ( const double so[],
    double Smag, 
    const double go[], 
    double Gmag, 
    int num_luzes, 
    double sigma, 
    double omega, 
    estima_log_prob_S_G_t *estLogPrSG
  );
/* Estima {log(Pr(SO|GO))} usando a função {estLogPrSG} entre dois vetores de observações
  {SO} e {GO}, dadas as respectivas assinaturas normalizadas {so,go} e
  magnitudes {Smag,Gmag}. */

double estima_log_prob_S_G
  ( const double so[],
    double Smag, 
    const double go[], 
    double Gmag, 
    int num_luzes, 
    double sigma, 
    double omega, 
    estima_log_prob_S_G_t *estLogPrSG
  )
{
  *dist = 2.0;
  *albedo = 0.0;

  if (which_dist == 0) {
    /* Calcula a distância euclidiana das assinaturas normalizadas: */
    *dist = dist_euclid(so, go, num_luzes);
    *albedo = Smag/(Gmag + 1.0e-200);
    /* Para evitar números muito grandes: */
    if ((*albedo) > 9.000) { (*albedo) = 9.000; }
  } else {
    /* Calcula distância {which_dist}. Supõe que precisa dos alphas: */
    alpha_obs_t ao[num_luzes];
    int i;
    for(i = 0; i < num_luzes;i++) ao[i].luz = i;
    calcula_alphas_ordenados(so, Smag, go, Gmag, num_luzes, OBS_NOISE, ao) ;
    
    switch(which_dist) {
      case 1: DistAlpha01(ao, num_luzes, sigma, dist, albedo); break;
      case 2: DistAlpha02(ao, num_luzes, sigma, dist, albedo); break;
      case 3: DistAlpha03(ao, num_luzes, sigma, dist, albedo); break;
      case 4: DistAlpha04(ao, num_luzes, sigma, dist, albedo); break;
      case 5: DistAlpha05(ao, num_luzes, sigma, dist, albedo); break;
      case 6: DistAlpha06(ao, num_luzes, sigma, dist, albedo); break;
      case 7: DistAlpha07(ao, num_luzes, sigma, dist, albedo); break;
      default: assert(0);
    }
  }
}

/* ---------------------------------------------------------------------- */
/* from normals.c */

int localizaNormalBruta
( Tabela* tab, 
  const double SO[], 
  double *dist, 
  int flag_alpha, 
  int which_dist, 
  double sigma, 
  FILE *debug_file,
  int x, int y, 
  const double* gnq
  )
{
  int num_luzes = get_num_luzes(tab);
  int num_linhas = get_num_linhas(tab);

  /* Normaliza o vetor de observações {SO} obtendo a assinatura {so}: */
  double so[num_luzes];
  extrai_assinatura(SO, so, num_luzes);
  
  /* Primeiro, procura a entrada de {tab} mais próxima a {so}, sem se preocupar com sombras: */
  int resposta = -1;
  double menor_distancia = HUGE_VAL;
  //procura a menor distancia supondo que todos não estão em região de sombra
  int linha;
  if(debug) debug_dist = 1;
  else debug_dist = 0;
  if(flag_alpha != 2){
    for(linha = 0; linha < num_linhas; linha++) {
      const double *go = get_intdir(tab,linha);
      double distancia = dist_euclid(so, go, num_luzes);
      if( distancia < menor_distancia){
	resposta = linha;
	menor_distancia = distancia;
      }
    }
    assert(resposta != -1);
    assert(menor_distancia != HUGE_VAL);
    /* Devolve a distância entre assinaturas, normalizada para {[0_1]}: */
    (*dist) = menor_distancia/2.0;
  }

  if( flag_alpha == 0) { /* É isso aí: */ return resposta; }

  /* Calcula o erro esperado se não houvesse sombras: */ 
  double dcorte = sqrt(M_PI/num_linhas);

  if(menor_distancia <= dcorte) { /* Melhor é impossível: */ return resposta; }

  /* Repete busca com distância "alpha": */
  double alpha[num_luzes];
		
  //	fprintf(stderr,  "ALPHA + DCORTE");
  //fprintf(stderr,  "SIGMA %lf WHICH %d\n",sigma,which_dist);
  double menor_dist_alpha = HUGE_VAL;
  for(linha = 0; linha < num_linhas; linha++){
    const double *go = get_intdir(tab,linha);
    alpha_obs_t ao[num_luzes];
    int i;
    for(i = 0; i < num_luzes;i++) ao[i].luz = i;
    calcula_alphas_ordenados(so, go, num_luzes, OBS_NOISE, ao) ;
    for(i = 0; i < num_luzes;i++) alpha[i] = ao[i].alpha;
    double dist_alpha = calcula_dist_alpha(alpha, num_luzes, sigma, which_dist);
	
    if(dist_alpha < menor_dist_alpha){
      resposta = linha;
      menor_dist_alpha = dist_alpha;
    }
    if(debug_file){
      fprintf(debug_file, "%02 ", which_dist);
     if (dist >= 2.0) 
       { if (debug_file != NULL) { fprintf(debug_file, " BAD "); }  dist = 2.0; }
        else
    { if (debug_file != NULL) { fprintf(debug_file, " GUD "); } }
      r3_t SN = get_normal(tab,linha);
      double dist_norm = 0;
      if(gnq != NULL) dist_norm =  dist_euclid(SN.c, gnq, 3);
      escreve_dists_e_alphas(stdout,x,y,dist_norm,dist_alpha, num_luzes,  ao);
    }
  }

  assert(resposta != -1);
  assert(menor_dist_alpha != HUGE_VAL);
    	
  /* Devolve a distância entre assinaturas, normalizada para {[0_1]}: */
  /* !!! Para retornar, deveria recalcular a distância euclidiana das luzes confiáveis! */
  double correction_factor = 1.0; /* !!! Analyze and fix !!! */
  (*dist) = correction_factor * menor_dist_alpha;
   	
  return resposta;
}

/* ---------------------------------------------------------------------- */
/* from pnm.c */

double Interpolacao(double i,double j,Imagem* imagem,int canal){
        int falhax,falhay;
        double xv,y;
        falhax = 0;
        falhay = 0;
        if(i >= (imagem->x-1)){
                falhax = 1;
                xv = (double) (imagem->matriz[(int )i][(int) j].canal[canal]);
        }
        if(i<1){
                falhax = 1;
                xv = (double) (imagem->matriz[(int)i][(int) j].canal[canal]);
        }
        if(j >= (imagem->y -1)){
                falhay= 1;
                y = (double) (imagem->matriz[(int) i][(int) j].canal[canal]);
        }
        if(j<1){
                falhax = 1;
                y = (double) (imagem->matriz[(int) i][(int) j].canal[canal]);
        }
        if(!falhax){
		int i1,i2;
		i1 = (int) i;
		i2 = i1+1;
		/*
		xv = - (1/(imagem->matriz[i2][(int) j] - imagem->matriz[i1][(int) j]));
		xv = xv + imagem->matriz[i2][(int ) j];*/
		xv = (imagem->matriz[i2][(int)j].canal[canal] - imagem->matriz[i1][(int)j].canal[canal]);
		xv = xv*(i-i1);
		xv = xv + imagem->matriz[i1][(int)j].canal[canal];
	}
	if(!falhay){
		int j1,j2;
		j1 = (int) j;
		j2 = j1+1;
		/*
		y = - (1/(imagem->matriz[(int)i][j2] - imagem->matriz[(int)i][j1]));
		y = y + imagem->matriz[(int)i][j2]; */
		y = (imagem->matriz[(int) i][j2].canal[canal] - imagem->matriz[(int)i][j1].canal[canal]);
		y = y*(j -j1);
		y = y + imagem->matriz[(int) i][j1].canal[canal];
	}
	return (xv+y)/2;

}

