#ifndef pnm_H
#define pnm_H

#define PNM_DEFAULT_MAXVAL 255
#define PNM_MAX_MAXVAL 255

#define VIEW_GAMMA 2.200
#define LINEAR_GAMMA 1.000
#define DEFAULT_GAMMA 1.000

typedef struct pixel {
  unsigned short int canal[3]; /* R,G,B */
} pixel;

typedef struct Imagem Imagem;

Imagem *image_alloc(int x, int y, int maxval);
/* Allocates a new image object {*image} (including its header) with {x} 
  columns and {y} rows. Sets its max pixel value to {maxval}. */

void image_free(Imagem **imagem);
/* De-allocates the image object {*image} (including its header). */

int get_width(Imagem* imagem);
int get_height(Imagem* imagem);
unsigned short int get_maxval(Imagem* imagem);

/* RAW PIXELS */

pixel get_pixel(Imagem* imagem,int x,int y);
void set_pixel(Imagem* imagem,int x, int y,pixel p);

unsigned short int get_sample(Imagem *imagem, int x, int y, int canal);
void set_sample(Imagem *imagem, int x, int y, int canal, unsigned short int grau);

/* LINEAR INTENSITIES */

double intensity_from_sample(short int grau, short int maxval, double gamma);
/* Converts the short int intensity value {grau}, assumed to be in {0..maxval}
  to a real value in [0_1], with gamma correction. */

short int sample_from_intensity(double v, short int maxval, double gamma);
/* Converts the real intensity value {v}, assumed to be in [0_1], 
  to a short int image sample in the range {0..maxval}, with gamma correction. */

double get_intensity(int x, int y, Imagem* imagem, int canal, double gamma);
/* Same as {pnm_intensity_from_sample(get_sample(imagem,x,y,canal),get_maxval(imagem))}. 
  If the pixel {x,y} lies outside the image's domain, uses the nearest pixel in the domain. */

/* INTERPOLATION */

double Catmull_Rom_spline(double t,double p0,double p1,double p2,double p3);

double image_interpolate_bicubic(double x, double y, Imagem* imagem, Imagem *mascara, int canal, double gamma);
double image_interpolate_bilinear(double x, double y, Imagem* imagem, int canal, double gamma);
/* Similar to {pnm_image_fetch(x,y,imagem,canal)}, but interpolates the 
  intensity values for fractional {x,y}.  The {mascara} image, if present,
  must have the same size as {imagem}, and identifies the pixels of {imagem}
  that have valid values (0 = invalid) */

/* PNM IMAGE I/O */

void pnm_image_read(char *nome, Imagem **novo);
/* Reads a PNM image file called {nome}, stores the image into a
  newly allocated {Imagem} object, saves the address of the latter 
  in {*novo}. */

Imagem** pnm_image_list_read(char** nome, int n);
/* Reads a vector of {n} images from PNM files whose names 
   are {nome[0..n-1]}. */

void pnm_image_write(char *nome, Imagem *imagem);
/* Writes the image {*imagem} to a PNM image file called {nome}. */

#endif
