/*Callback functions for the polinomial interpolation !*/
#include <polynomial_functions.h>
#include <ls_system.h>
#include <affirm.h>
#include <stdlib.h>

int NoValidation(double* c, int basis_size, bool_t* validity_array);
// int NoValidation(double* c, int basis_size, bool_t* validity_array){
//   return basis_size;
// }


ls_model_t* create_ls_polynomial_model(void){
  
  ls_model_t* lm = (ls_model_t*) malloc(sizeof(ls_model_t));
  //lm->ls_data = NULL;
  lm->type = 0;
  lm->num_weights = 0;
  lm->weights = NULL;
  lm->wpos  = NULL;
  lm->phi = poly_phi;
  lm->get_num_components = poly_get_number_components;
  lm->retrieve_components = poly_retrieve_components;
  lm->update_weights = poly_update_weights;
  lm->validate_results= NoValidation;
  lm->evaluate = poly_evaluate;
  lm->write_param = poly_write_params;
  lm->copy_data =  poly_copy_lighting_data;
  lm->compare = poly_compare;
  lm->release_data = poly_release_lighting_data;
  lm->compute_pos_weights = poly_compute_pos_weights;
  
  return lm;
  
}

poly_function_t* poly_init_components(int dimensions,int degree){
  poly_function_t* pl = (poly_function_t*)malloc(sizeof(poly_function_t));
  pl->dimensions = dimensions;
  
  pl->coefs = CreateCoeficientsVector(degree,pl->dimensions,&(pl->num_coefs));
  pl->weights = (double*)malloc(sizeof(double)*(pl->num_coefs));
  int i;
  for(i = 0; i < pl->num_coefs; i++){
     pl->weights[i] = 1;
  }
  return pl;
}

double poly_phi(int r, double* x,void* l_data){
  poly_function_t* pl = (poly_function_t*)l_data;
  demand(r < pl->num_coefs, "poly_phi: Invalid coeficient index !");
  double* coefs = pl->coefs[r];
  return EvaluateXE(pl->dimensions, x, coefs);
}

int poly_get_number_components(void* l_data){
  poly_function_t* pl = (poly_function_t*)l_data;
  return pl->num_coefs;
}

void poly_retrieve_components(double* C, int n,void* l_data){
  poly_function_t* pl = (poly_function_t*)l_data;
  int i ;
  demand(n <= pl->num_coefs,"poly_retrieve_components: Invalid number of coeficients !");
  for(i = 0; i < pl->num_coefs; i++){
    if(i < n){
      pl->weights[i] = C[i];
    }else{
      pl->weights[i] = 0;
    }
  }
}

void poly_update_weights(void* l_data,double** X, double* F,double* weights, int n,double* sigma){
    /*Do nothing, i dont know how update weights yet*/
}

double poly_evaluate(double* x,void* l_data){
  poly_function_t* pl = (poly_function_t*)l_data;
  return EvaluatePvalue(pl,x);
}

void poly_write_params(FILE* arq,void* l_data){
  poly_function_t* pl = (poly_function_t*)l_data;
  PrintfPolyFunction(arq ,pl);
}
void* poly_copy_lighting_data(void* l_data){
  poly_function_t* pl = (poly_function_t*)l_data;
  poly_function_t* pl_new = (poly_function_t*)malloc(sizeof(poly_function_t));
  pl_new->dimensions = pl->dimensions;
  pl_new->num_coefs = pl->num_coefs;
  pl_new->weights = (double*)malloc(sizeof(double)*(pl->num_coefs));
  int i;
  pl_new->coefs = (double**)malloc(sizeof(double*)*(pl->num_coefs));
  for(i = 0; i < pl->num_coefs;i++){
    pl_new->coefs[i] = (double*)malloc(sizeof(double)*(pl->dimensions));
    int j;
    for(j = 0;j < pl->dimensions; j++){
      pl_new->coefs[i][j] = pl->coefs[i][j];
    }
    pl_new->weights[i] = pl->weights[i];
  }
  
  return pl_new;
}

double poly_compare(void* l_data1,void* l_data2){
  poly_function_t* pl1 = (poly_function_t*)l_data1;
  poly_function_t* pl2 = (poly_function_t*)l_data2;
  return rn_dist(pl1->num_coefs, pl1->weights,pl2->weights);
}

void poly_release_lighting_data(void* l_data){
  poly_function_t* pl = (poly_function_t*)l_data;
  free(pl->weights);
  int i;
  for(i = 0; i < pl->num_coefs; i++){
    free(pl->coefs[i]);
  }
  free(pl->coefs);
  free(pl);
}

double poly_compute_pos_weights(double* x,void* l_data){
  return 1;
}

