/* Resoluo de sistemas esparsos de equaes. */
/* Last edited on 2005-08-15 13:24:57 by stolfi */ 

#ifndef sistema_H
#define sistema_H

#define MAXCOEFS 5

typedef struct equacao_t
  { long int ind[5];  /* {ind[k]}  o ndice de uma incgnita que entra na equao. */
    double coef[5];   /* Coeficiente dessa incgnita. */
    double indep;     /* Termo constante da equao. */
  } equacao_t;
  /* Um registro do tipo {equacao_t} representa uma equao linear 
     envolvendo at {MAXCOEFS} incgnitas, da forma
      {SOMA {coef[k]*Z[ind[k]] : k = 0..MAXCOEFS-1} == indep},
     onde {Z[0..N-1]}  o vetor com todas as incgnitas.
     Entradas vazias so indicadas por {ind[k] == -1}. */

typedef struct sistema_t
  { long int N;
    equacao_t* eq;
  } sistema_t;
  /* Um {sistema_t} representa {N} equaes lineares {eq[0..N-1]} sobre
    {N} incgnitas {Z[0..N-1}. */

sistema_t* cria_sistema(long int N);
  /* Cria um sistema linear com {N} equaes para {N} incgnitas. 
     No inicializa nenhum coeficiente, ndice ou termo independente. */

void resolve_sistema
  ( sistema_t* S, 
    double *Z, 
    long int max_iter, 
    double tol,
    int para, 
    int szero
  );
  /* Resolve o sistema {S}. A soluo  armazenada no vetor {Z[0..N-1}}
     onde {N = S->N}. 
     
     Usa o mtodo iterativo de Gauss-Jordan, e portanto supe que a
     incgnita {Z[i]} aparece na equao {S->eq[i]}, para {i =
     0..S->N-1}, com coeficiente ``suficientemente grande. 
     O chute inicial  o valor de {Z} na entrada do procedimento. Executa
     no mximo {max_iter} iteraes, mas termina quando duas iteraes
     consecutivas no mudam nenhuma incgnita mais do que a tolerncia
     {tol}.

     Se {para == 1}, usa forma ``paralela da iterao de Gauss, seno 
     usa a forma sequencial (Gauss-Jordan). Se {szero == 1},
     ajusta a soluo de modo a ter soma zero, aps cada iterao. */
 
double calcula_dif_total(double* Zvelho, double* Z, long int N);
  /* Retorna o mximo de {abs(Zvelho[i]-Z[i])}, para {i = 0..N-1}. */

#endif
