#! /bin/bash
# Last edited on 2006-04-26 08:44:58 by stolfi
 
PROG_NAME=${0##*/}
PROG_DESC="model bash script"
PROG_HELP=(
  "${PROG_NAME} \\"
  "\n    [ -boolop ] [ -intop {INT} ] \\"
  "\n    {NAME} {FRACTION} \\"
  "\n    < {INFILE} > {OUTFILE}"
)
PROG_INFO=(
  "\nNAME"
  "\n  ${PROG_NAME} - ${PROG_DESC}."
  "\n"
  "\nSYNOPSIS"
  "\n  export MYENV={VAL}"
  "\n  ${PROG_HELP[@]}"
  "\n"
  "\nDESCRIPTION"
  "\n  Does nothing, nothing, bla {NAME} bla bla bla, bla bla"
  "\n  bla bla bla bla bla bla, {FRACTION} bla bla bla bla."
  "\n"
  "\n  Then bla bla bla bla some more."
  "\n"
  "\n  Additional output files are"
  "\n"
  "\n    {NAME}-banana.png - blablabla bla bla."
  "\n    {NAME}-{INT}-banana.png - blablabla bla bla."
  "\n"
  "\nSEE ALSO"
  "\n  bla-bla-bla(1)"
  "\n  blabber(1)"
  "\nAUTHOR"
  "\n  Created 1950-11-29 by Jorge Stolfi, Unicamp"
)

# ----------------------------------------------------------------------
# INTERNAL OPTIONS

booloptwo=1
intoptwo=10

# ----------------------------------------------------------------------
# COMMAND LINE PARSING

# Parse command line switches: 
boolop=0
intop=4615
while [[ ( $# -ge 1 ) && ( "/$1" =~ "/-.*" ) ]]; do
  if [[ ( $# -ge 1 ) && ( "/$1" == "/-boolop" ) ]]; then 
    boolop=1; shift;
  elif [[ ( $# -ge 2 ) && ( "/$1" == "/-intop" ) ]]; then 
    intop="$2"; shift; shift;
  else
    echo "unknown option $1" 1>&2 ;
    echo -e "usage:\n  ${PROG_HELP[@]}" 1>&2 ; exit 1 
  fi
done 

# Get positional parameters
if [[ $# -ge 2 ]]; then
  name=$1; shift;
  fraction=$1; shift;
else
  echo 'wrong number of arguments "'"$1"'" ...' 1>&2 ;
  echo -e "usage:\n  ${PROG_HELP[@]}" 1>&2 ; exit 1 
fi

# Check for leftover arguments:
if [[ $# -ne 0 ]]; then
  echo 'wrong number of arguments "'"$1"'" ...' 1>&2 ;
  echo -e "usage:\n  ${PROG_HELP[@]}" 1>&2 ; exit 1 
fi

# END COMMAND LINE PARSING
# ----------------------------------------------------------------------

# Temporary file name prefix:
tmp="/tmp/$$"

if [[ ${booloptwo} -gt 0 ]]; then
  ls ${tmp}-errs.txt | head -${intop}
fi

# Cleanup
/bin/rm -rf ${tmp}-* ${tmp}.*
