#ifndef __CAMERA_SDL_H__
#define __CAMERA_SDL_H__

#include <dc1394/dc1394.h>
#include <SDL.h>

struct sdl_screen_t{
  SDL_Surface* screen;
  SDL_Overlay* bmp;
  unsigned char* scratch_buffer_bit;
  unsigned char* scratch_buffer_bayer;
  uint32_t w,h,bit_depth;
};

typedef struct sdl_screen_t sdl_screen_t;

sdl_screen_t*  InitSDLScreen(dc1394camera_t* camera);
void releaseSDLScreen(sdl_screen_t* ss);
void displayFrame(sdl_screen_t* ss, dc1394video_frame_t *frame);


#endif