#ifndef __CAMERA_SETUP_H__
#define __CAMERA_SETUP_H__

#include <dc1394/dc1394.h>
#include <r2.h>

int determine_videomode(int format,int mode,int coding,int depth,dc1394video_mode_t* videomode, dc1394color_coding_t* colorcoding);
/*If the combination of  video format, coding, depth and mode are compatible
with dc1394 standards , return TRUE and set {videomode} to the correspondent value, if not, return FALSE.*/

dc1394_t* session_init(void);
/*init a dc1394 session. Acctualy it is just a call for a dc1394 function*/

int session_get_num_devices(dc1394_t* session);
/*Returns the numbers of devices available in a session*/

dc1394error_t session_close(dc1394_t* session);
/*Closes dc1394 session*/

void session_list_devices(dc1394_t* session,FILE* arq);
/*Prints into {arq} the enumerated devices off a session*/

dc1394camera_t* camera_get_device(dc1394_t* session,  int deviceNum);
/*Request access to a device , returns NULL in case of any problem*/

void camera_print_capabilities(dc1394camera_t* camera, FILE* arq);
/*Prints in human-readable form the camera capabilities and available modes*/

dc1394error_t session_reset_device(dc1394_t* session,int deviceNum);
/*resets a given device ,reseting bus information*/

dc1394error_t session_reset_all_devices(dc1394_t* session);
/*resets all devices ,reseting bus information*/


dc1394error_t camera_release(dc1394camera_t* camera);
/*Release camera, making it available for other processes*/

dc1394error_t camera_auto_init(dc1394camera_t* camera);
/*Auto configure the camera with the first available settings.
It means the slowest framerate, lowest format and 8bit depth (YUV or MONO)
, with ISO 400 speed (it is meant to be compatible with EVERYTHING) 
*/

dc1394error_t camera_init(dc1394camera_t* camera,
			  dc1394video_mode_t videomode,
			  dc1394color_coding_t colorcoding,
			  dc1394speed_t isospeed,
			  dc1394framerate_t framerate,
			  r2_t* roiDimensions,
			  r2_t* roiPosition
			  );
/*Configure the camera with the given settings. The camera may not be compatible with 
the specified parameters, in this case it will return a error.
Notice that {colorcoding},{roiDimensions} and {roiPosition} would be used ONLY if video mode is format7-friendly,
otherwise they will be ignored since they are automatically set in another formats.
{framerate} parameter is ignored in format7 videomodes since they rely in the isospeed and packet size
to set the framerate*/

void camera_print_settings(dc1394camera_t* camera, FILE* arq);
/*Prints in human-readable form the camera current settings*/

dc1394error_t camera_copy_frame(dc1394video_frame_t* orig,dc1394video_frame_t* dest);
/*Copy frame and alocate image in process memory from a frame to another*/

dc1394error_t camera_flush_DMA(dc1394camera_t* camera);

#endif