#define PROG_NAME "comvert_params"

#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <r2.h>
#include <r3.h>
#include <i2.h>
#include <limits.h>
#include <time.h>
#include <argparser.h>

#define PROG_HELP \
  PROG_NAME " \\\n" \
  "    -prefix {FILE_PREFIX} \\\n" \
  "    " argparser_help_info_HELP ""

#define PROG_INFO \
  "NAME\n" \
  "  Etc. etc..\n" \
  "\n" \
  "SYNOPSIS\n" \
  PROG_HELP "\n" \
  "\n" \
  "OPTIONS" \
  "  Etc. etc.."

void separate_args(int argc, char** argv, FILE* arq_GAB,FILE* arq_TAB);

void separate_args(int argc, char** argv, FILE* arq_GAB,FILE* arq_TAB){
	argparser_t *pp = argparser_new(stderr, argc, argv);
	argparser_set_help(pp, PROG_HELP);
	argparser_set_info(pp, PROG_INFO);
	argparser_process_help_info_options(pp);
	
	
	
	char* channels;
	if (argparser_keyword_present(pp, "-channels")) {
		channels = argparser_get_next(pp);
	} else {
// 		channels = "RGB";
	}
	
	fprintf(arq_GAB, "  -channels %s \n",channels);
	//fprintf(arq_TAB, "  -channels %s \n",channels);
	
	int tableSize;
	if (argparser_keyword_present(pp, "-tableSize")) {
		tableSize = argparser_get_next_int(pp, 2, 1000);
	} else {
		tableSize = 30;
	}
	fprintf(arq_GAB, "  -tableSize %d \n",tableSize);
	
	
	
	int nGauges;
	if (argparser_keyword_present(pp, "-nGauges")) {
		nGauges = argparser_get_next_int(pp, 1, 100);
	} else {
		nGauges = 1;
	}
	fprintf(arq_GAB,"    -nGauges %d \n",nGauges);
	fprintf(arq_TAB,"    -nGauges %d \n",nGauges);
	
	argparser_get_keyword(pp, "-gaugeCenter");
	fprintf(arq_GAB, "  -gaugeCenter\n");
	int indice;
	for(indice = 0 ; indice < nGauges; indice++){
		r2_t gaugeCenter;
		gaugeCenter.c[0] = argparser_get_next_double(pp, 0.0, 100000.0);
		gaugeCenter.c[1] = argparser_get_next_double(pp, 0.0, 100000.0);
		fprintf(arq_GAB, " %lf %lf \n", gaugeCenter.c[0], gaugeCenter.c[1]);
	}

	argparser_get_keyword(pp, "-gaugeRadius");
	
	fprintf(arq_GAB, "  -gaugeRadius\n");
	for(indice = 0 ; indice < nGauges; indice++){
		double gaugeRadius = argparser_get_next_double(pp, 1.0, 100000.0);
		fprintf(arq_GAB, "%lf \n", gaugeRadius);
	}
	
	
	if( argparser_keyword_present(pp, "-gaugeStretch") ){
		fprintf(arq_GAB, "  -gaugeStretch\n");
		for(indice = 0 ; indice < nGauges; indice++){
			r2_t gaugeStretch;
			gaugeStretch.c[0] = argparser_get_next_double(pp, -1000000.0, 100000.0);
			gaugeStretch.c[1] = argparser_get_next_double(pp, -1000000.0, 100000.0);
			fprintf(arq_GAB, " %lf %lf\n", gaugeStretch.c[0],gaugeStretch.c[1]);
		}
		
	}else{
		//gaugeStretch = (r2_t){{0,0}};
	}
	
	if( argparser_keyword_present(pp, "-gaugeViewDir") ){
		fprintf(arq_GAB, "  -gaugeViewDir\n");
		for(indice = 0 ; indice < nGauges; indice++){
			r3_t gaugeViewDir;
			gaugeViewDir.c[0] = argparser_get_next_double(pp, -1000000.0, 100000.0);
			gaugeViewDir.c[1] = argparser_get_next_double(pp, -1000000.0, 100000.0);
			gaugeViewDir.c[2] = argparser_get_next_double(pp, -1000000.0, 100000.0);
			fprintf(arq_GAB, " %lf %lf %lf\n", gaugeViewDir.c[0],gaugeViewDir.c[1],gaugeViewDir.c[2]);
		}
	}
	
	argparser_get_keyword(pp, "-nLights");
	int nLights = argparser_get_next_int(pp, 3, 1000);
	fprintf(arq_GAB, "  -nLights %d \n", nLights);
	fprintf(arq_TAB, "  -nLights %d \n", nLights);
	
// 	argparser_get_keyword(pp, "-prefix");
// 	char* prefix = argparser_get_next(pp);
// 	fprintf(arq_GAB, "  -prefix %s \\\n", prefix);
// 	fprintf(arq_TAB, "  -prefix %s \\\n", prefix);
// 	

	
	argparser_get_keyword(pp, "-gaugeImages");
	fprintf(arq_GAB,"-gaugeImages\n");
//	char** gauge_image_name = (char**) malloc(sizeof(char*)*(nLights*nGauges));
	fprintf(stderr, "Gabaritos:\n");
	int ind;
	for (ind = 0; ind < (nLights*nGauges); ind++){
		char* gab_arq = argparser_get_next(pp);
		fprintf(stderr, "    G[%02d] = %s\n",  ind, gab_arq);
		fprintf(arq_GAB,"%s\n",gab_arq);
	}
	
	if(argparser_keyword_present(pp, "-gaugeDirections") ){
		fprintf(arq_GAB,"-gaugeDirections\n");
		char** gauge_direction_name = (char**) malloc(sizeof(char*)*(nLights*nGauges));
		fprintf(stderr, "Gabaritos - DIRECOES:\n");
		for (ind = 0; ind < (nLights*nGauges); ind++){
			gauge_direction_name[ind] = argparser_get_next(pp);
			if(gauge_direction_name[ind] == NULL){ 
				printf("puts !");
			}
			fprintf(stderr, "    Dir[%02d] = %s\n",  ind, gauge_direction_name[ind]);
			fprintf(arq_GAB," %s \n",gauge_direction_name[ind]);
			
		}
		//gaugeDirections = (r3_t*)malloc(sizeof(r3_t)*o->nLights);
	}
	
	
	r2_t* gaugePos = (r2_t*)malloc(sizeof(r2_t)*(nGauges));
	if (argparser_keyword_present(pp, "-gaugePos")) {
		fprintf(arq_GAB,"-gaugePos\n");
		for (ind =0; ind < nGauges; ind++){
			gaugePos[ind].c[0] = argparser_get_next_double(pp, -100000.0, +200000.0);
			gaugePos[ind].c[1] = argparser_get_next_double(pp, -100000.0, +200000.0);
			fprintf(stderr, "    [%02d] %lf  %lf \\\n", ind, gaugePos[ind].c[0], gaugePos[ind].c[1]);
			fprintf(arq_GAB, "  %lf  %lf \n", gaugePos[ind].c[0], gaugePos[ind].c[1]);
			
		}
	} else {
		if (nGauges > 1) { 
			argparser_error(pp, "Must spcify \"-gaugePos\" when there are multiple gauges");
		} else {
			for (ind =0; ind < nGauges; ind++){
				gaugePos[ind] = (r2_t){{ 0,0 }};
			}
		}
	}
	
	fprintf(stderr, "  -gaugeAlbedo\n");
	fprintf(arq_GAB, "  -gaugeAlbedo\n");
	fprintf(arq_TAB, "  -gaugeAlbedo\n");
	r3_t gaugeAlbedo;
	if (argparser_keyword_present(pp, "-gaugeAlbedo")) {
			
		for(indice = 0; indice < nGauges; indice++){
			gaugeAlbedo.c[0] = argparser_get_next_double(pp, 0.001, 1.000);
			gaugeAlbedo.c[1] = argparser_get_next_double(pp, 0.001, 1.000);
			gaugeAlbedo.c[2] = argparser_get_next_double(pp, 0.001, 1.000);
			fprintf(arq_GAB, " %5.3lf %5.3lf %5.3lf \n", gaugeAlbedo.c[0],gaugeAlbedo.c[1],gaugeAlbedo.c[2]);
			fprintf(arq_TAB, " %5.3lf %5.3lf %5.3lf \n", gaugeAlbedo.c[0],gaugeAlbedo.c[1],gaugeAlbedo.c[2]);
			fprintf(stderr, " %5.3lf %5.3lf %5.3lf \\\n", gaugeAlbedo.c[0],gaugeAlbedo.c[1],gaugeAlbedo.c[2]);
		}
		
	} else {
		for(indice = 0; indice < nGauges; indice++){
			gaugeAlbedo.c[0] = gaugeAlbedo.c[1] = gaugeAlbedo.c[2] = 1.000;
			fprintf(arq_GAB, " %5.3lf %5.3lf %5.3lf \n", gaugeAlbedo.c[0],gaugeAlbedo.c[1],gaugeAlbedo.c[2]);
			fprintf(arq_TAB, " %5.3lf %5.3lf %5.3lf \n", gaugeAlbedo.c[0],gaugeAlbedo.c[1],gaugeAlbedo.c[2]);
			fprintf(stderr, " %5.3lf %5.3lf %5.3lf \\\n", gaugeAlbedo.c[0],gaugeAlbedo.c[1],gaugeAlbedo.c[2]);
		}
	}
	
	
	
	argparser_get_keyword(pp, "-gamma");
	double gamma = argparser_get_next_double(pp, 0.100, 9.000);
	fprintf(stderr, "Gamma das imagens:%lf \n", gamma);
	fprintf(arq_GAB, "-gamma %lf", gamma);
	fprintf(arq_TAB, "-gamma %lf", gamma);
	
	//int gray = argparser_keyword_present(pp, "-gray");

	int logProbFunction;
	if (argparser_keyword_present(pp, "-logProbFunction")) {
    		logProbFunction = argparser_get_next_int(pp, 0, 999);
  	} else {
    		logProbFunction = 0;
  	}
  	fprintf(stderr, "   -logProbFunction %d \\\n",logProbFunction);
	fprintf(arq_TAB, "  -logProbFunction %d \n", logProbFunction);

	
  	if (argparser_keyword_present(pp, "-albedoFunction")) {
		int albedoFunction;
    		albedoFunction = argparser_get_next_int(pp, 0, 999);
		fprintf(arq_TAB," -albedoFunction %d\n",albedoFunction);
  	}
  	
	
  	if (argparser_keyword_present(pp, "-sigma")) {
		double sigma;
    		sigma = argparser_get_next_double(pp, 0.0001, 10.0000);
		fprintf(arq_TAB, "  -sigma %lf \n", sigma);
  	}

  	if (argparser_keyword_present(pp, "-omega")) {
		double omg0,omg1;
    		omg0 = argparser_get_next_double(pp, 0.0001, 10.0000);
    		omg1 = argparser_get_next_double(pp, 0.0001, 10.0000);
		fprintf(arq_TAB, "  -omega %lf %lf \n", omg0, omg1);
  	}
  	

  	
	int hMin,hMax,vMin,vMax;
  	if (argparser_keyword_present(pp, "-rectangle")) {
    		hMin = argparser_get_next_int(pp, INT_MIN, INT_MAX);
    		hMax = argparser_get_next_int(pp, hMin, INT_MAX);
    		vMin = argparser_get_next_int(pp, INT_MIN, INT_MAX);
    		vMax = argparser_get_next_int(pp, vMin, INT_MAX);
    		fprintf(stderr, "  -rectangle %d %d  %d %d \\\n", hMin, hMax, vMin, vMax);
		fprintf(arq_TAB,"  -rectangle %d %d  %d %d \n", hMin, hMax, vMin, vMax);
  	}  	


	argparser_get_keyword(pp, "-sceneImages");
	fprintf(arq_TAB,"-sceneImages\n");
  	fprintf(stderr, "Imagens:\n");
  	char** scene_image_name = (char**) malloc(sizeof(char*)*(nLights));
  	for (ind = 0; ind < (nLights); ind++){
    		scene_image_name[ind] = argparser_get_next(pp);
    		fprintf(stderr, "    S[%02d] = %s\n", ind, scene_image_name[ind]);
		fprintf(arq_TAB," %s\n",scene_image_name[ind]);
  	}

  
  
	int gridSize;
  	if (argparser_keyword_present(pp, "-gridSize")) {
    		gridSize = argparser_get_next_int(pp, 1, 1000000);
		fprintf(arq_TAB,"   -gridSize %d \n",gridSize);
  	} else {
    		gridSize = -1;
  	}
  	
	fprintf(stderr,"   -gridSize %d \\\n",gridSize);

  
  	if(argparser_keyword_present(pp,"-showBucketsPPM")){
		fprintf(stderr,"    -showBucketsPPM \\\n");
		fprintf(arq_TAB,"    -showBucketsPPM \n");
  	} 
  	
  	if(argparser_keyword_present(pp,"-showBucketsEPS")){
		fprintf(stderr,"    -showBucketsEPS \\\n");
		fprintf(arq_TAB,"   -showBucketsEPS\n");
  	} 
  	

  	if(argparser_keyword_present(pp,"-showBucketsPLT")){
		fprintf(stderr,"    -showBucketsPLT \\\n");
		fprintf(arq_TAB,"    -showBucketsPLT \n");
  	} 
  	  
  	
  	if(argparser_keyword_present(pp,"-performanceTestOnly") ){
		fprintf(stderr,"    -performanceTestOnly\\\n");
		fprintf(arq_TAB,"   -performanceTestOnly\n");
   	}

	
  	if(argparser_keyword_present(pp,"-numSubsets") ){
		int numSubsets;
		numSubsets = argparser_get_next_int(pp, 1, 1000000);
		fprintf(stderr,"    -numSubsets %d\\\n",numSubsets);
		fprintf(arq_TAB,"    -numSubsets %d\n",numSubsets);
		argparser_get_keyword(pp,"-subsetSize");
		int subsetSize = argparser_get_next_int(pp, 3, 100000);
		fprintf(stderr,"    -subsetSize %d\\\n",subsetSize);
		fprintf(arq_TAB,"    -subsetSize %d\n",subsetSize);
		int random_subsets = !argparser_keyword_present(pp,"-subsets");
		if(random_subsets){
			fprintf(stderr,"USING Random Subsets\n");
		}else{
			fprintf(stderr,"USING User-Defined Subsets\n");
			fprintf(arq_TAB,"-subsets\n");
		}
		int** subsets = (int**)malloc(sizeof(int*)*(numSubsets));
		srand ( time(NULL) );
		for(ind = 0; ind < numSubsets;ind++){
			subsets[ind] = (int*)malloc(sizeof(int)*(subsetSize));
		}
		if(!random_subsets){
			for(ind = 0; ind < numSubsets; ind ++){
				int ind2;
				for(ind2 = 0; ind2 < subsetSize; ind2++){
					subsets[ind][ind2] = argparser_get_next_int(pp,0, 100000);
					fprintf(arq_TAB," %d\n",subsets[ind][ind2]);
				}
			}
		}
		
	}
	
	
  	if (argparser_keyword_present(pp, "-refNormalMap")) {
		char* refNormalMap;
    		refNormalMap = argparser_get_next(pp);
    		fprintf(stderr, "  -refNormalMap %s \\\n", refNormalMap);
		fprintf(arq_TAB, "  -refNormalMap %s \n", refNormalMap);
 	}
  	/* Analisa opção de hash: */
  	if (argparser_keyword_present(pp, "-brute")){
    		fprintf(arq_TAB,"-brute\n");
    		
  	} else if (argparser_keyword_present(pp, "-hash")){
    		fprintf(arq_TAB,"-hash\n");
  	} else if (argparser_keyword_present(pp, "-bruteAndHash")){
    		fprintf(arq_TAB,"-bruteAndHash\n");
  	} else if (argparser_keyword_present(pp, "-superTable")){
    		fprintf(arq_TAB,"-superTable\n");
  	} else {
    		argparser_error(pp, "Must specify a hash/brute option");
  	}

  	/* Analisa opção de estimador de probabilidade usada na busca: */
  	if (argparser_keyword_present(pp, "-nsig")) {
    		fprintf(arq_TAB,"-nsig\n");
  	} else if (argparser_keyword_present(pp, "-alpha")) {
    		fprintf(arq_TAB,"-alpha\n");
  	} else if (argparser_keyword_present(pp, "-nsigOrAlpha")) {
    		fprintf(arq_TAB,"-nsigOrAlpha\n");
  	} else {
    		argparser_error(pp, "Must specify an alpha/nsig option");
  	}

	 	
  	/* Opções de debug: */
  	if (argparser_keyword_present(pp, "-debug")) {
		fprintf(arq_TAB,"-debug\n");
    		int nDebug = argparser_get_next_int(pp, 0, INT_MAX);
		fprintf(arq_TAB," %d ",nDebug);
    		i2_t* debug = (i2_t*) malloc(nDebug * sizeof(i2_t));
    		int id;
    		for (id = 0; id < nDebug; id++) {
      			debug[id].c[0] = argparser_get_next_int(pp, 0, INT_MAX);
      			debug[id].c[1] = argparser_get_next_int(pp, 0, INT_MAX);
      			fprintf(stderr, "  debugging pixel [%d %d] (PNM indices)\n",debug[id].c[0], debug[id].c[1]);
			fprintf(arq_TAB," %d %d ",debug[id].c[0],debug[id].c[1]);
    		}
  	} 
  	argparser_finish(pp);
	
}

int main(int argc, char** argv){
	char* prefix;
	char* param_filename;
	char* gab_filename;
	char* tab_filename;
	
	if(argc < 2){
		fprintf(stderr,"program usage:\n");
		fprintf(stderr,"convert_params PREFIX\n");
		
	}
	prefix = argv[1];
	asprintf(&param_filename,"%s/params.txt",prefix);
	asprintf(&gab_filename,"%s/params_gab.txt",prefix);
	asprintf(&tab_filename,"%s/params_tab.txt",prefix);

	FILE* param_file = fopen(param_filename,"rt");
	if(!param_file){
		fprintf(stderr,"Failled to open %s\n",param_filename);
		return 1;
	}
	/* Now read whole file to put on memory*/
	int count_words = 0;
	char test[500];
	int max_word = -1;
	while(fscanf(param_file,"%s",test) != EOF){
		if(test[0] != '#'){
			if(strlen(test) > max_word) {
				max_word = strlen(test);
			}
			count_words++;
		}else{
			char c;
			do{
				c = fgetc(param_file);
			}while ((c != EOF) && (c!='\n'));
		}
	}
	
	fclose(param_file);
	count_words = count_words+1;
	param_file = fopen(param_filename,"rt");
	char** content = (char**)malloc(sizeof(char*)*(count_words+1));
	content[0] = "PROGRAM NAME";
	int i = 1;
	while(fscanf(param_file,"%s",test) != EOF){
		if(test[0] != '#'){
			content[i] =  (char*)malloc(sizeof(char)*(strlen(test) +1));
			strcpy(content[i],test);
			i++;
		}else{
			char c;
			do{
				c = fgetc(param_file);
			}while ((c != EOF) && (c!='\n'));
		}
	}
	fclose(param_file);

	FILE* treco = fopen("treco.txt","wt");
	for(i = 0; i < count_words;i++){
		fprintf(treco,"%s\n",content[i]);
	}
	fclose(treco);

	FILE* gab_file = fopen(gab_filename,"wt");
	FILE* tab_file = fopen(tab_filename,"wt");
	
	separate_args(count_words,content, gab_file,tab_file);

	fclose(gab_file);
	fclose(tab_file);	

	return 0;
}
