// Persistence Of Vision raytracer version 3.5 sample file.
//
// -w320 -h240
// -w800 -h600 +a0.3

global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "shapes.inc"
/*
camera {
  location <0, 105, 50>
  up <0, 0, 1>
  sky <0, 0, 1>
  look_at <0, 0, 0>
}*/

#declare pie_slice = 
intersection{
  plane { +x, 0 }
  plane { +y, 0 }
}

#declare pie_rest = 
union{
  plane { -x, 0 }
  plane { -y, 0 }
}

background { color rgb <0.900, 0.950, 1.000>  }

#include "boxes.inc"
#declare plotSz = 1/3 ;

#macro sliced_plot(slicer, perturb, displace)
  // Returns the intersection of the plot with ({slicer} translated by {perturb})
  // Translates the result by {displace}.
  intersection{
    object{ slicer translate perturb }
      union{ 
	object{grid_sticks
		texture{
			pigment {gradient z 
				 pigment_map {
       					[0.5 color rgb <1.000, 0.300, 0.100>]
        			 	[0.5 color rgb <1.000, 0.700, 0.100>]
      				}
				scale <1,1,2> translate <0,0,0.0000001>
			}
			finish  {diffuse 0.8 ambient 0.2}
		}
		
	}
	object{grid_plate
		texture{
			pigment {color rgb <1.000, 0.800, 0.500> } 
			finish  {diffuse 0.8 ambient 0.2}
		}
		
	}
	translate <-(grid_size)/2.0,-(grid_size)/2.0, 0>
	scale < 1, 1 ,(plotSz*grid_size)/max_value >
	rotate 60*z
    }
    translate displace
  }
#end

sliced_plot(pie_slice, <-0.00001, -0.00001, 0.0>, grid_size*<+0.2, +0.2, 0.0>)
sliced_plot(pie_rest, <+0.00001, +0.00001, 0.0>, grid_size*<-0.2, -0.2, 0.0>)

#declare camera_disp = 3*grid_size*<0.3,0.4,0.3>;
#declare camera_radius = 0.7*grid_size;
#declare camera_focus = <0,0,0> ;
#declare image_rel_width = image_width;
#declare image_rel_height = image_height;

light_source { vrotate(camera_disp,  30*z) + 0.5*vlength(camera_disp)*z color rgb 0.20*<1,1,1> }
light_source { vrotate(camera_disp, -35*z) + 0.4*vlength(camera_disp)*z color rgb 0.25*<1,1,1> }
light_source { vrotate(camera_disp,  15*z) + 0.3*vlength(camera_disp)*z color rgb 0.45*<1,1,1> }
light_source { vrotate(camera_disp, -20*z) + 0.2*vlength(camera_disp)*z color rgb 0.40*<1,1,1> }


#include "camera.inc"